<?php
/*
	Sets up and displays the "Create a child" tab for the Add-ons susbystem.
	
	A child add-on is associated with a parent add-on and provides additional options or
	selections for an attendee, such as side trips for an excursion, prepaid bookings for
	part of a trip and the like.
	
	A regular ("parent", non-child) add-on has a null addon_parent field. A child add-on
	has its parent add-on's addon_id in the addon_parent field.
	
	No checking is done for recursion yet, although it should be.
	
	Stephanie Mitchell, 25 September, 2019.
*/
/*
	See if logged in via Quadodo
*/
global $tpl;
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "header.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
header('Location: /qls/login.php');
exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$group = $_REQUEST['group'];

require_once ".config.php";
require_once "setup.php";
require_once "fieldlist.php";
require_once "template_options.php";
require_once "mysql_utilities.php";
mysql_login('Normal');

$mydata = get_mysql_fields($group, $fields, $primarykeyfieldname, $primarykeyfieldvalue, $db['tb']);

/*	Force a distinctive addon name to identify the new record */

$mydata['addon_name'] .= ' (CHILD)';
$mydata['addon_parent'] = $mydata[$primarykeyfieldname];	//	Link parent
$mydata['addon_read_more'] = ">EDIT THIS: {$mydata['addon_read_more']}";
$mydata['addon_desc'] = ">EDIT THIS: {$mydata['addon_desc']}";

/*	Insert the new record and get the new auto_increment id */
$sql = "INSERT INTO regaddons (`{$primarykeyfieldname}`) VALUES (NULL)";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on AddOn INSERT: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'AddOn record addition failed - sorry!');

$newid = mysqli_insert_id($GLOBALS['dbConnect']);
$mydata[$primarykeyfieldname] = $newid;

/*	Generate the query to update the new record with the child placeholder values. */

$sql = "UPDATE regaddons SET ";
foreach ($mydata as $key => $value) {
	if ($key != $primarykeyfieldname) {
		if (isset($fields[$key]['copyValue'])) {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$fields[$key]['copyValue']).'", ';
		} else {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$value).'", ';
		}
	}
} 

$sql = rtrim($sql, ', '); // lop off extra trailing comma
$sql .= " WHERE {$primarykeyfieldname}={$newid}";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on AddOn UPDATE: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'AddOn data copy failed - sorry!');
$sql_escaped = mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
Make_Log_Entry($GLOBALS['dbConnect'], "NEW ADDON ADDED VIA COPY: $sql_escaped");
mysql_logout();	//	Disconnect from database

$e = new Smarty_Esprit;
$e->registerPlugin("modifier","ss", "stripslashes");
$e->assign('mydata',$mydata);
// print_r($tpl);
$e->addTemplateDir("$dirname/templates");
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
$e->display('addons_detail.tpl');

?>
