<?php

/*	Protect from non-logged in users */

define('QUADODO_IN_SYSTEM', true);

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

require_once ".config.php";
require_once "header.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
header('Location: qls/login.php');
exit;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<title>Esprit Rate Calculator</title>
<link href="css/helpstyles.css" rel="stylesheet" type="text/css" />
<style>
.label {font-weight: bold; color: #888888;}
.value {font-weight: normal;}
</style>
</head>

<body style="background-color: #FFEEEE; padding: 6px;">
<?php
/* Calculate package rates by code */

$tier = (isset($_REQUEST['tier']) ? $_REQUEST['tier'] : 1);
require_once "mysql_utilities.php";
mysql_login('Read-only');

$sql = "SELECT DISTINCT pkg_type
	FROM regpackages
	WHERE pkg_tier=$tier
	AND (pkg_available IS NULL
		OR pkg_available = 'Yes')
	ORDER BY pkg_type;";
$sql .= "SELECT DISTINCT pkg_form_type
	FROM regpackages
	WHERE pkg_tier=$tier
	AND (pkg_available IS NULL
		OR pkg_available = 'Yes')
	ORDER BY pkg_form_type;";
$sql .= "SELECT DISTINCT pkg_name
	FROM regpackages
	WHERE pkg_tier=$tier
	AND (pkg_available IS NULL
		OR pkg_available = 'Yes')
	ORDER BY pkg_name;";
$sql .= "SELECT *
	FROM regpackages
	WHERE pkg_tier=$tier
	AND (pkg_available IS NULL
		OR pkg_available = 'Yes')
	ORDER BY pkg_type, pkg_form_type, pkg_name;";

/*	Get meal types and costs */

$sql .= "SELECT *
	FROM regmealtypes
	ORDER BY mt_abbr;";

	

$sql_result = mysqli_multi_query($GLOBALS['dbConnect'], $sql) or SM_Die(' Database error while initialising calculator (pkg_types): '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Initialising calculator failed (1) - sorry!');
/*	Store pkg_type values for menu */
$r = mysqli_store_result($GLOBALS['dbConnect']);
while ($d = mysqli_fetch_assoc($r)) {
	$pkg_type[] = $d['pkg_type'];
}
/*	Store pkg_form_type values for menu */
mysqli_next_result($GLOBALS['dbConnect']) or SM_Die(' Database error while initialising calculator ((form types)): '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Initialising calculator failed (2) - sorry!');
$r = mysqli_store_result($GLOBALS['dbConnect']);
while ($d = mysqli_fetch_assoc($r)) {
	$pkg_form_type[] = $d['pkg_form_type'];
}
/*	Store pkg_name values for menu */
mysqli_next_result($GLOBALS['dbConnect']) or SM_Die(' Database error while initialising calculator (pkg_names): '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Initialising calculator failed (3) - sorry!');
$r = mysqli_store_result($GLOBALS['dbConnect']);
while ($d = mysqli_fetch_assoc($r)) {
	$pkg_name[] = $d['pkg_name'];
}
/*	Store row contents for stay details */
mysqli_next_result($GLOBALS['dbConnect']) or SM_Die(' Database error while initialising calculator (stay details): '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Initialising calculator failed (4) - sorry!');
$r = mysqli_store_result($GLOBALS['dbConnect']);
while ($d = mysqli_fetch_assoc($r)) {
	$row[$d['pkg_type']][$d['pkg_form_type']][$d['pkg_name']]['pkg_rate'] = 0+$d['pkg_rate'];
	$row[$d['pkg_type']][$d['pkg_form_type']][$d['pkg_name']]['pkg_code'] = $d['pkg_code'];
}
/*	Store row contents for meal details */
mysqli_next_result($GLOBALS['dbConnect']) or SM_Die(' Database error while initialising calculator (meal details): '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Initialising calculator failed (5) - sorry!');
$r = mysqli_store_result($GLOBALS['dbConnect']);
while ($d = mysqli_fetch_assoc($r)) {
	$mealtypes[$d['mt_long']]['mt_long'] = $d['mt_long'];
	$mealtypes[$d['mt_long']]['mt_verbose'] = $d['mt_verbose'];
	$mealtypes[$d['mt_long']]['mt_cost'] = $d['mt_cost'];
	$mealtypes[$d['mt_long']]['mt_id'] = $d['mt_id'];
}
// print '<pre>';var_dump($packages); print '</pre>';

// print '<pre>Pkg_type:'; var_dump($pkg_type); print '</pre>';
// print '<pre>Pkg_form_type:'; var_dump($pkg_form_type); print '</pre>';
// print '<pre>Pkg_name:'; var_dump($pkg_name); print '</pre>';
// print '<pre>Row:'; var_dump($row); print '</pre>';
// exit;

// print '<pre>';
// print_r($_REQUEST);
// print '</pre>';

define('INVALID_SEL', '<span class="bold bad">Invalid or incomplete selection</span>');
$r_stay = (isset($_REQUEST['stay']) ? $_REQUEST['stay'] : 'SS');
$r_regtype = (isset($_REQUEST['regtype']) ? $_REQUEST['regtype'] : 'F');
$r_rate = (isset($_REQUEST['rate']) ? $_REQUEST['rate'] : 'FR');

$pkgcode = "$r_stay-$r_regtype-$r_rate";
$amount = (isset($pkg[$pkgcode]['rate']) ? $pkg[$pkgcode]['rate'] : INVALID_SEL);

$r_newstay = (isset($_REQUEST['newstay']) ? $_REQUEST['newstay'] : 'SS');
$r_newregtype = (isset($_REQUEST['newregtype']) ? $_REQUEST['newregtype'] : 'F');
$r_newrate = (isset($_REQUEST['newrate']) ? $_REQUEST['newrate'] : 'FR');

$newpkgcode = "$r_newstay-$r_newregtype-$r_newrate";
$newamount = (isset($pkg[$newpkgcode]['rate']) ? $pkg[$newpkgcode]['rate'] : INVALID_SEL);

// print "Package code: $pkgcode; rate: $amount<br>";
?>
<h2>Esprit Registration System Calculator</h2>
<h3>Convention Rates:</h3>
<form id="rateform" name="rates" method="post" action="calculator.php">
Tier: <select name="tier" onChange="this.form.submit();">
<?php
	for ($this_tier = 1; $this_tier <=5; $this_tier++) {
		print "<option name=\"tier\" value=\"$this_tier\"";
		if ($this_tier == $tier) {
			print ' SELECTED ';
		}
		print ">$this_tier</option>";
	}
	print '</select>';
?>
<table border="0" cellpadding="3px" cellspacing="0" class="edit">
<tr>
	<td></td><td class="label">Days</td><td class="label">Type</td><td class="label">Rate</td><td class="label">Amount</td>
</tr>

<tr>
<!-- Generate current stay info -->
	<td class="label"> Current Stay:</td>
	<td class="value"> 
	<?php print "<select name=\"stay\" onChange=\"this.form.submit();\">";
	foreach ($pkg_type as $stay) {
		print "<option name=\"stay\" value=\"$stay\"";
		if ($r_stay == $stay) {
			print ' SELECTED ';
		}
		print "> $stay </option>";
	}
	print '</select>';
	?>
	</td>
	<td class="value">
	<?php print "<select name=\"regtype\" onChange=\"this.form.submit();\">";
	foreach ($pkg_form_type as $regtype) {
		print "<option name=\"regtype\" value=\"$regtype\"";
		if ($r_regtype == $regtype) {
			print ' SELECTED ';
		}
		print "> $regtype </option>";
	}
	print '</select>';
	?>
	</td>
	<td class="value">
	<?php print "<select name=\"rate\" onChange=\"this.form.submit();\">";
	foreach ($pkg_name as $rate) {
		print "<option name=\"rate\" value=\"$rate\"";
		if ($r_rate == $rate) {
			print ' SELECTED ';
		}
		print "> $rate </option>";
	}
	print '</select>';
	?>
	</td>
	<td class="value">
	<?php
	$amount = isset($row[$r_stay][$r_regtype][$r_rate]['pkg_rate']) ?
	$row[$r_stay][$r_regtype][$r_rate]['pkg_rate'] : INVALID_SEL;
	if (is_numeric($amount)) {
		print sprintf("$%.2f",$amount);
	} else {
		print $amount;
	}?>
	</td>
</tr>

<tr>
<!-- Generate updated stay info -->
	<td class="label"> Updated Stay:</td>
	<td class="value"> 
	<?php print "<select name=\"newstay\" onChange=\"this.form.submit();\">";
	foreach ($pkg_type as $stay) {
		print "<option name=\"newstay\" value=\"$stay\"";
		if ($r_newstay == $stay) {
			print ' SELECTED ';
		}
		print "> $stay </option>";
	}
	print '</select>';
	?>
	</td>
	<td class="value">
	<?php print "<select name=\"newregtype\" onChange=\"this.form.submit();\">";
	foreach ($pkg_form_type as $regtype) {
		print "<option name=\"newregtype\" value=\"$regtype\"";
		if ($r_newregtype == $regtype) {
			print ' SELECTED ';
		}
		print "> $regtype </option>";
	}
	print '</select>';
	?>
	</td>
	<td class="value">
	<?php print "<select name=\"newrate\" onChange=\"this.form.submit();\">";
	foreach ($pkg_name as $rate) {
		print "<option name=\"newrate\" value=\"$rate\"";
		if ($r_newrate == $rate) {
			print ' SELECTED ';
		}
		print "> $rate </option>";
	}
	print '</select>';
	?>
	</td>
	<td class="value">
	<?php
	$newamount = isset($row[$r_newstay][$r_newregtype][$r_newrate]['pkg_rate']) ?
	$row[$r_newstay][$r_newregtype][$r_newrate]['pkg_rate'] : INVALID_SEL;
	if (is_numeric($newamount)) {
		print sprintf("$%.2f",$newamount);
	} else {
		print $newamount;
	}?>
	</td>
</tr>

<tr>
<td class="label">Difference:</td>
<td class="value" colspan="3">
	<?php print sprintf("$%.2f",$newamount - $amount);
	print ($newamount<=$amount) ? '<span class="bold good"> to be REFUNDED</span>' : '<span class="bold bad"> to be CHARGED</span>';
	?>
</td>
</tr>
</table>
<p>&nbsp;</p>

<!--	Meal Prices section -->

<h3>Meal Prices:</h3>
  <table border="0" cellpadding="3px" cellspacing="0" class="edit">
  <tr>
  <td></td>
  <td class="label right">Price each</td>
  <td class="label right">Current Count</td>
  <td class="label right">Current Cost</td>
  <td class="label right">Updated Count</td>
  <td class="label right">Updated Cost</td>
</td>
</tr><?php
$oldcounts = array(0, 1, 2, 3, 4, 5);	// for computing differences
$newcounts = $oldcounts;
$oldtotal = 0;
$newtotal = 0;
foreach ($mealtypes as $thismeal) {
	$mealid = $thismeal['mt_id'];
	print "
<tr>
	<td width=\"30%\" class=\"label\">{$thismeal['mt_long']}:</td>
	<td width=\"10%\" class=\"value\" style=\"text-align: right\">".sprintf("$%.2f", $thismeal['mt_cost'])."</td>";

	print "<td width=\"10%\" class=\"value right\"><select name=\"old$mealid\" onChange=\"this.form.submit();\">";
	foreach ($oldcounts as $old=>$oldval) {
		print "<option name=\"old$mealid\" value=\"$old\"";
		$r_oldmeal[$mealid] = (isset($_REQUEST["old$mealid"]) ? $_REQUEST["old$mealid"] : 0);
		if ($r_oldmeal[$mealid] == $old) {
			print ' SELECTED ';
		}
		print "> $old </option>";
	}
	print '</select></td>';
	$oldcost = $r_oldmeal[$mealid] * $thismeal['mt_cost'];
	$oldtotal += $oldcost;
	print "<td width=\"10%\" class=\"value\" style=\"text-align: right\">\$$oldcost</td>";

	print "<td width=\"10%\" class=\"value\" style=\"text-align: right\"><select name=\"new$mealid\" onChange=\"this.form.submit();\">";
	foreach ($newcounts as $new=>$newval) {
		print "<option name=\"new$mealid\" value=\"$new\"";
		$r_newmeal[$mealid] = (isset($_REQUEST["new$mealid"]) ? $_REQUEST["new$mealid"] : 0);
		if ($r_newmeal[$mealid] == $new) {
			print ' SELECTED ';
		}
	print "> $new </option>";
	}
	print '</select></td>';
	$newcost = $r_newmeal[$mealid] * $thismeal['mt_cost'];
	$newtotal += $newcost;
	print "<td width=\"10%\" class=\"value\" style=\"text-align: right\">\$$newcost</td>";

      print "<td class=\"value\">&nbsp;</td>
    </tr>";
}
$difference = $newtotal - $oldtotal;
print "<tr><td width=\"10%\" class=\"label\">TOTALS:</td><td></td><td></td><td class=\"value\" style=\"text-align: right\">".sprintf("$%.2f", $oldtotal)."</td><td></td><td class=\"value\" style=\"text-align: right\">".sprintf("$%.2f", $newtotal)."</td></tr>";
print "<tr><td width=\"10%\" class=\"label\">DIFFERENCE:</td>";
print "<td class=\"value\" style=\"text-align: right\" colspan=\"2\">";
print sprintf("$%.2f",$difference);
print $difference<=0 ? '<span class="bold good"> to be REFUNDED</span>' : '<span class="bold bad"> to be CHARGED</span>';
	?>
</td>
  </table>
</form>
<p>&nbsp;</p>
</body>
</html>
