<?php
/*
	Sets up and displays the "Copy" tab for the Letters susbystem.
	
	Stephanie Mitchell, 4 April, 2023
*/
/*
	See if logged in via Quadodo
*/

global $tpl;
define('QUADODO_IN_SYSTEM', true);
$dirname = dirname(__FILE__);
$basename = dirname($dirname);

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "mysql_utilities.php";
require_once "header.php";
require_once ".config.php";
require_once "setup.php";
require_once "fieldlist.php";
require_once "template_options.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
	header('Location: ../qls/login.php');
	exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$group = $_REQUEST['group'];
$all_years = $_REQUEST['all_years'] ?? '';
mysql_login('Normal');

$mydata = get_mysql_fields($group, $fields, $primarykeyfieldname, $primarykeyfieldvalue, $db['tb']);

/*
	Force a distinctive group name to identify the new record
*/

$mydata['letter_group'] .= ' (NEW)';

// insert the new record and get the new auto_increment id
$sql = "INSERT INTO regletters (`{$primarykeyfieldname}`) VALUES (NULL)";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on Letters INSERT: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Letters add failed - sorry!');

$newid = mysqli_insert_id($GLOBALS['dbConnect']);
$mydata[$primarykeyfieldname] = $newid;

/*
	Generate the query to update the new record with the previous values.
*/

$sql = "UPDATE regletters SET ";
foreach ($mydata as $key => $value) {
	if ($key != $primarykeyfieldname) {
		if (isset($fields[$key]['copyValue'])) {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$fields[$key]['copyValue']).'", ';
		} else {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$value).'", ';
		}
	}
} 

$sql = rtrim($sql, ', '); // lop off extra trailing comma
$sql .= " WHERE {$primarykeyfieldname}={$newid}";
$sql_escaped = $sql; // mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
$result = mysqli_query($GLOBALS['dbConnect'], $sql_escaped) or SM_Die('Database error on update while copying Letter: ' . mysqli_error($GLOBALS['dbConnect']) . ". Query=$sql_escaped", 'Unable to update information while copying Letter - sorry!');

Make_Log_Entry($GLOBALS['dbConnect'], "NEW LETTER ADDED VIA COPY TO CURRENT: $sql_escaped");

$e = new Smarty_Esprit;
$e->addPluginsDir("{$_SERVER['DOCUMENT_ROOT']}/plugins/");
$e->registerPlugin("modifier","ss", "stripslashes");
$e->assign('mydata',$mydata);
// print_r($tpl);
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/$dirname/templates/");
$e->display('letters_detail.tpl');
?>
