<?php

/*
	MySQL utility functions
*/

/*
	mysql_login
	Checks to see if there is already a connection object in $GLOBALS['dbConnect'].
	Establishes a MySQL connection and sets the global if
	not.
*/
function mysql_login($id = 'Normal') {
	global $db, $tpl;
	if (isset($GLOBALS['dbConnect'])) {
		if (is_object($GLOBALS['dbConnect'])) {
			if (isset($db['type'])) {
				if ($db['type'] == $id) {
					$tpl['access'] = $id;
					return;		//	Connection object exists; nothing to do
				} else {
// 					print "Logging out as {$db['type']} in order to login as $id<br />";
					mysqli_close($GLOBALS['dbConnect']);
				}
			}
		}
	}
	
	require_once dirname(dirname(__FILE__)) . "/lib/.auth/.regconnect.php"; // hostname, ID and password
	$dbnew = get_regconnect($id);
	if (isset($db)) {
		$db = array_replace($db, $dbnew);
	} else {
		$db = $dbnew;
	}
// 	print '<pre>$dbnew:';print_r($dbnew); print '</pre><br />';
// 	print __FUNCTION__ . ": connected to \$db['hn']={$db['hn']}<br />";
// 	print '<pre>$db:';print_r($db); print '</pre><br />';

	$GLOBALS['dbConnect'] = mysqli_connect($db['hn'], $db['un'], $db['pw'], $db['db']) or die(__FUNCTION__ . ": Couldn't connect to database server: " . mysqli_error($GLOBALS['dbConnect']));
	
	//	Get rid of pesky only_full_group_by mode if set.
	
	$set_mode = "SET SESSION sql_mode=REPLACE(REPLACE(REPLACE(@@SESSION.sql_mode, 'ONLY_FULL_GROUP_BY', ''),'NO_ZERO_DATE', ''),'NO_ZERO_IN_DATE', '')";
	$result = mysqli_query($GLOBALS['dbConnect'], $set_mode) or die(__FILE__.'/'.__LINE__.': Database error setting session modes: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$set_mode);
	$tpl['access'] = $id;
	return;	 //	No value returned; result is the setting of the global
}
/*
	mysql_logout
	Checks to see if there is already a connection object in $GLOBALS['dbConnect']. Closes
	the connection and deletes the $GLOBALS['dbConnect'] object if so.
*/
function mysql_logout() {
	if (isset($GLOBALS['dbConnect'])) {
		mysqli_close($GLOBALS['dbConnect']);
		unset($GLOBALS['dbConnect']);
	}
}

function get_mysql_fields($group, $fields, $primarykeyfieldname, $primarykeyfieldvalue, $tb, $join_clause = '', $alias = '') {

//	  print '<pre>'; print_r(func_get_args()); print '</pre>';
	/*	  This selects field lists based on their fieldgroup from fieldlist.php.
		-	If the $group parameter appears in the fieldgroup the field will be
			selected.
		-	If the fieldgroup includes	 "*" that field will always be selected
			regardless of the value of the $group parameter.
		-	if the $group parameter is "*" then all fields will always be
			selected.
		-	If $alias is supplied (i.e. not null) then only fields with that
			value in their table element (i.e. in that table) will be selected.
	*/
	mysql_login();
	if ($join_clause != '') {
		$join_clause .= ' AND';
	}
// print "get_mysql_fields: \$group: $group; \$fields: $fields; \$primarykeyfieldname: $primarykeyfieldname; \$primarykeyfieldvalue: $primarykeyfieldvalue; \$tb: $tb; \$join_clause: $join_clause;";
	
	$fieldlist = '';
		
	foreach ($fields as $thisfieldname => $thisfield) {
		if (!isset($thisfield['callback'])) {	 // Can't do callback
												// (calculated) fields
			//	  Include every field?
			if (($group == '*') or
				//	  Always include this field? (fieldgroup contains '*')
				(strpos('..'.$thisfield['fieldgroup'], '*') > 0) or
				//	  Include this field because it matches?
				(strpos('..'.$thisfield['fieldgroup'], $group) > 0) or
				//	Include this field because $alias parameter specifies it?
				isset($alias) ? $thisfield['table'] == $alias : false)
				{
			
			

				$fieldlist .= (isset($thisfield['table']) ? "{$thisfield['table']}." : '') . $thisfieldname . ', ';
			}
		}
	}
	$fieldlist = rtrim($fieldlist, ', ');
	
	$sql = "SELECT $fieldlist
	FROM $tb
	WHERE $join_clause $primarykeyfieldname=$primarykeyfieldvalue";
//   print "SQL command: $sql\n\n";
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
	$row_count_result = mysqli_query($GLOBALS['dbConnect'], 'select FOUND_ROWS() as row_count') or die(__FILE__.'/'.__LINE__.": Database error (counting): " . mysqli_error($GLOBALS['dbConnect']));
	$row = mysqli_fetch_assoc($result);
  // print '<pre>';print_r($row);print '</pre>';
	foreach ($row as $key => $val) {
		$v[$key] = (is_null($val) ? null : stripslashes($val));
	}
	return $v;
}

function get_mysql_fields_for_duplicate($group, $fields, $primarykeyfieldname, $primarykeyfieldvalue, $db) {

//	  print '<pre>'; print_r(func_get_args()); print '</pre>';
	/*	  This selects field lists based on their table alias from fieldlist.php.
		-	 if the [$fieldname]['table'] is missing the field is included.
		-	 If $db['alias'] is null or is the same as the [$fieldname]['table']
			then the field will be included.
	*/
	mysql_login();
	$tb = $db['tbnoalias'];
//	print __FUNCTION__ . ": \$group: $group; \$fields: $fields; \$primarykeyfieldname: $primarykeyfieldname; \$primarykeyfieldvalue: $primarykeyfieldvalue; \$db: $db; \$tb: $tb;";

	$fieldlist = '';
		
	foreach ($fields as $thisfieldname => $thisfield) {
		if (!isset($thisfield['callback'])) {	 // Can't do callback
												// (calculated) fields
			//	  Does this field have a table spec?
			$doit = (isset($db['alias']) ? 
				(isset($thisfield['table']) ? 
					($db['alias'] == $thisfield['table']) : true) : true);
			if ($doit) {
				$fieldlist .= (isset($thisfield['table']) ? $thisfield['table'] . '.' : '') . $thisfieldname . ', ';
			}
		}
	}
	$fieldlist = rtrim($fieldlist, ', ');
	
	$sql = "SELECT $fieldlist
	FROM $tb
	WHERE $primarykeyfieldname=$primarykeyfieldvalue";	
	//	  print "SQL command: $sql\n\n";
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
	$row_count_result = mysqli_query($GLOBALS['dbConnect'], 'select FOUND_ROWS() as row_count') or die(__FILE__.'/'.__LINE__.": Database error (counting): " . mysqli_error($GLOBALS['dbConnect']));
	$row = mysqli_fetch_assoc($result);
//	  print '<pre>';print_r($row);print '</pre>';
	foreach ($row as $key => $val) {
		$v[$key] = stripslashes($val);
	}
	return $v;
}

function add_mysql_record($tb, $fieldname, $fieldvalue) {
	
	mysql_login();
		
	$sql = "INSERT INTO $tb ($fieldname) VALUES(\"$fieldvalue\");";
	$result = mysqli_query( $GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.": Database INSERT error on main query: " . mysqli_error($GLOBALS['dbConnect']) . " Query=$sql");
}

function delete_mysql_record($tb, $primarykeyfieldname, $primarykeyfieldvalue) {
	
	mysql_login();
		
	$sql = "DELETE
	FROM $tb
	WHERE $primarykeyfieldname = $primarykeyfieldvalue;";
//	  print "\SQL: $sql. ";
	$result = mysqli_query( $GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.": Database DELETE error on main query: " . mysqli_error($GLOBALS['dbConnect']) . " Query=$sql");
}

/*
	sql_insert
	Insert supplied values into a table.
*/
function sql_insert($table, $valuesRaw, $execute=true) {

	mysql_login();
	$values = array_map_recursive('mysqli_real_escape_string', $valuesRaw);
	$sql = "INSERT INTO $table(";
	$sql .= implode(', ',array_keys($values)) .') ';
	$v = '"' . implode('", "', $values) . '"';
	$sql .= "VALUES($v)";
// 	die("\$sql insert=$sql");
	if ($execute) {	//	Are we testing or executing?
		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on INSERT: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to insert a record into the database - sorry! Query: ' . $sql);
	} else {
//		print_r($values); print '<br /><br />';
// 	print "<h4>" . __FUNCTION__ . ":</h4> SQL INSERT statement: $sql";
	}
	return $sql;
}

/*
	get_mysql_reports
	Extracts reports from the regreports table for the subsystem passed in $subsystem.
	Reports are returned as an array of groups with each group containing an array of the
	report names. Groups are returned in alphabetical order; reports within them are
	ordered by their sequence number.
	One-click reports (as invoked by buttons on various screens) are excluded from this
	result.
*/
function get_mysql_reports($subsystem, $usergroup = null) {
	
	mysql_login();
	global $tpl, $date, $mealnames, $packages, $esprit_year;
	global $appname, $selections, $where_selections, $order_clause;
	require_once dirname(dirname(__FILE__)) . "/lib/.auth/.config.php";
	$appname = $_SESSION['appname'];
	$selections = isset($_SESSION[$appname]['selections']) ? $_SESSION[$appname]['selections'] : '';
	$where_selections = isset($_SESSION[$appname]['where_selections']) ? $_SESSION[$appname]['where_selections'] : '';
	$order_clause = isset($_SESSION[$appname]['order_clause']) ? $_SESSION[$appname]['order_clause'] : ' ';
/*	Check $config_file_version. 2019 and older, or unset uses a different date/time mechanism from 2020. */
// var_dump($date);
// exit;
// 	if(!isset($GLOBALS['config_file_version'])) {
// 		foreach ($date as $k => $d) {	 // parse all dates into datetimes
// 			$tpl['datetime'][$k] = strftime('%F %T', $date[$d]);
// 			print "$k: {$tpl['datetime'][$k]}<br />";
// 		}
// 	} elseif ($GLOBALS['config_file_version'] >= "2020") {
// 		foreach ($date as $k => $d) {	 // parse all dates into datetimes
// 			$tpl['datetime'][$k] = $date[$d]->format('Y-m-d H:i:s');
// 			print "$k: {$tpl['datetime'][$k]}<br />";
// 		}
// 	} else {
// 		die('Invalid config file version in ' . __FILE__ . '/' . __FUNCTION__ . ': ' . __LINE__);
// 	}
	$this_authgroup = $usergroup;
	
/*
	Check for online Esprit instead of in-person, restrict report offerings
*/
	require("online_switch.php");

	$online_esprit = (ONLINE_ESPRIT ? 'AND report_esprit_online = "Yes"': 'AND report_esprit_online != "Yes"');

	$sql = "SELECT report_name name, report_sequence sequence,
		report_template template, report_query query, report_heading heading,
		report_preamble report_preamble, report_additional additional,
		report_download download_file,
		report_download_format report_download_format,
		report_group report_group, report_template_text template_text,
		report_is_oneclick report_is_oneclick
	FROM regreports
	WHERE report_system LIKE \"$subsystem\"
		AND report_authgroup LIKE \"%$this_authgroup%\"
		$online_esprit
	ORDER BY report_group,sequence, name";
// 	print $sql; exit;
	$result = mysqli_query( $GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.": Database error on report selection query: " . mysqli_error($GLOBALS['dbConnect']) . " Query=$sql");

	$newgroup = '';
	$arr = array();		//	Initially empty, will stay that way if there are no
						//	reports in the database
	/* Generate separator for this group */
	while ($row = mysqli_fetch_assoc($result)) {
		if ($row['report_group'] != $newgroup) {
			$arr["-- {$row['report_group']} --"] = '';
		}
		$n = array_shift($row);
		foreach ($row as $thisname => $thisvalue) {
			$thisvalue = $thisvalue ?? '';

			$v = stripslashes(html_entity_decode($thisvalue));
			if ($thisname == 'additional') {
// 				print "<h2>" . __FUNCTION__ . '/' . __LINE__ . ": Dump of pre-eval code \$v:</h2><pre>" . var_export($v,true) . "</pre>";
				eval($v);	 // should store additional values in $row
			/*	  exclude templates from sustitution as they contain Smarty code,
			which shouldn't be evaluated */
			} elseif ((strpos($v, '$') > 0) and (strpos($thisname, 'template') === false)) {
// print __FUNCTION__ . ": \$thisname=$thisname; \$v (pre-eval) = $v<br />";
				$v = preg_replace_callback("/[$][a-zA-Z0-9_]+/", function($varname) {
					return $GLOBALS[substr($varname[0], 1)];
				}, $v);
// print __FUNCTION__ . ": \$thisname=$thisname; \$v (post-eval) = $v<br /><br /><br />";
				$row[$thisname] = $v;	 // store translated version
			} else {
				$row[$thisname] = $v;
			}
		}
		$arr[$n] = $row;
		$newgroup = $row['report_group'];
	}
// 	   print '<pre>'; print_r(array_keys($arr)); print '</pre>';
	return $arr;
}
	
/*
	get_mysql_letters
	Extracts letters from the regletters table for the subsystem passed in
	$subsystem. Letters are returned as an array of groups with each group
	containing an array of the letter names. Groups are returned in alphabetical
	order; letters within them are ordered by their sequence number. Parameters:
	$subsystem		the subsystem to which this letter belongs
	$usergroup		the group of the user logged in, for authorisation purposes
*/

function get_mysql_letters($subsystem, $usergroup = null) {
	
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

	mysql_login();
	$this_authgroup = $usergroup;
	require_once ".config.php";

/*	ONLINE_ESPRIT switch. This switch actually lives in a separate file where it can be
	referenced without including this entire file (which can cause other errors). See the 
	notes in that file.
*/
	include_once("online_switch.php");

	$online_esprit = (ONLINE_ESPRIT == true ? 'AND letter_online_esprit = "Yes"': 'AND letter_online_esprit != "Yes"');

	$sql = "SELECT letter_group letter_group, letter_name letter_name,
		letter_sequence letter_sequence,
		letter_template_text letter_template_text,
		letter_from letter_from, letter_to letter_to,
		letter_replyto letter_replyto, letter_cc letter_cc,
		letter_bcc letter_bcc, letter_subject letter_subject,
		letter_bulkable letter_bulkable, letter_bulk_sql letter_bulk_sql,
		letter_base_sql letter_base_sql,letter_id letter_id
	FROM regletters
	WHERE letter_system LIKE \"$subsystem\"
		AND letter_authgroup LIKE \"%$this_authgroup%\"
		$online_esprit
	ORDER BY letter_group, letter_sequence, letter_name";
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.": Database error on letter selection query: " . mysqli_error($GLOBALS['dbConnect']) . " Query=$sql");

	$newgroup = '';
	$arr = array();		//	Initially empty, will stay that way if there are no
						//	letters in the database
	/* Generate separator for this group */
	while ($row = mysqli_fetch_assoc($result)) {
		if ($row['letter_group'] != $newgroup) {
			$thisgroup = $row['letter_group'];
			$arr[$thisgroup] = array();	  //	Start new group
		}
// 	  print '<pre>$row';print_r($row); print '</pre>';			  
		$thisrow = $row;
		/*	  assemble letter elements into $r */
		foreach ($thisrow as $thisname => $thisvalue) {
			$thisvalue = $thisvalue ?? '';
			$r[$thisname] = stripslashes(html_entity_decode($thisvalue));
// 		   if ($thisname == 'letter_template_text') {	 //	   shorten for testing
// 			   $r[$thisname] = 'Debugging text';
// 		   }
		}
// 	   print __FUNCTION__.': <pre>$row (post-decode): ';print_r($row); print '</pre>';			  
		$arr[$thisgroup][] = $r;
		$newgroup = $thisgroup;
	}
// 	  print __FUNCTION__.': <pre> returned letter array:';print_r($arr); print '</pre>';
	return $arr;
}

/*
	Make_Log_Entry
	Add an entry to the log database. Automatically applies current timestamp
	and username. Logfile table name is taken from constant defined in
	.config.php.
*/

function Make_Log_Entry($connection, $entry) {
	global $tpl;
	
	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

	if (!defined('QUADODO_IN_SYSTEM')) {
		define('QUADODO_IN_SYSTEM', true);
		
		require_once "header.php";
		$authgroup = $qls->group_id_to_name($qls->user_info['group_id']);
		$username = $qls->user_info['username'];
		$user_and_group = "$username:$authgroup";
	} elseif (isset($_COOKIE['espritbadgereader'])) {	//	Are we being called from the
														//	badge scanner?
		$user_and_group = $_COOKIE['espritbadgereader']['scannername'] . ':Badge/' . $_COOKIE['espritbadgereader']['class'];
	} else {
			
		$user_and_group = "{$tpl['username']}:{$tpl['authgroup']}";
	}
	
	if ($user_and_group == ':') {	//	Are we not logged in?
		$user_and_group = '* Not logged in *';
	}
	require_once dirname(dirname(__FILE__)) . "/lib/.auth/.config.php";
	mysql_login();
	$logfile = _LOGFILENAME;
	
	$entry = mysqli_real_escape_string($GLOBALS['dbConnect'], nl2br(htmlentities($entry)));
	//	Timestamp is inserted automatically as default value by MySQL
	$sqlquery = "INSERT INTO $logfile (user, entry)
		VALUES ('$user_and_group', '$entry')";
	$result = mysqli_query($GLOBALS['dbConnect'], $sqlquery) or SM_Die("Database error adding log entry: " .mysqli_error($GLOBALS['dbConnect']) . ". Query: $sqlquery", 'Unable to add log entry - sorry!' . mysqli_error($GLOBALS['dbConnect']));
	mysql_logout();
}

/*
	Make_Email_Log_Entry
	Add an entry to the email log database. This basically copies the formatted
	email and related info into the email logfile so that an email can be
	re-sent if required.
*/

function Make_Email_Log_Entry($r, $source_system, $status_message) {
	global $tpl;

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

	if (!defined('QUADODO_IN_SYSTEM')) {
		define('QUADODO_IN_SYSTEM', true);
		require_once "header.php";
		$authgroup = $qls->group_id_to_name($qls->user_info['group_id']);
		$username = $qls->user_info['username'];
		$user_and_group = "$username:$authgroup";
	} else {
		$user_and_group = "{$tpl['username']}:{$tpl['authgroup']}";
	}
	require_once ".config.php";
	mysql_login();
	
	/*	Sanitise log entry */
	$from_addr = mysqli_real_escape_string($GLOBALS['dbConnect'], $r['letter_from']);
	$to_addr = mysqli_real_escape_string($GLOBALS['dbConnect'], $r['letter_to']);
	$replyto_addr = mysqli_real_escape_string($GLOBALS['dbConnect'], $r['letter_replyto'] ?? '');
	$cc_addr = mysqli_real_escape_string($GLOBALS['dbConnect'], $r['letter_cc']);
	$bcc_addr = mysqli_real_escape_string($GLOBALS['dbConnect'], $r['letter_bcc']);
	$subject = mysqli_real_escape_string($GLOBALS['dbConnect'], $r['letter_subject']);
/*	Sometimes the body content is in letter_html; use if so */
	if (isset($r['letter_html'])) {	
		$body = mysqli_real_escape_string($GLOBALS['dbConnect'], $r['letter_html']);
	} else {	//	Other times it's in letter_body
		$body = mysqli_real_escape_string($GLOBALS['dbConnect'], $r['letter_body']);
	}
	$source_system = mysqli_real_escape_string($GLOBALS['dbConnect'], $source_system);
	$status_message = mysqli_real_escape_string($GLOBALS['dbConnect'], $status_message);
	
	$logfile = _EMAIL_LOGFILENAME;
	$sqlquery = "INSERT INTO $logfile (send_date, source_system, from_addr, to_addr, replyto_addr, cc_addr, bcc_addr, subject, body, status)
		VALUES (now(), '$source_system', '$from_addr', '$to_addr', '$replyto_addr', '$cc_addr', '$bcc_addr', '$subject', '$body', '$status_message')";
// print $sqlquery;
	$result = mysqli_query($GLOBALS['dbConnect'], $sqlquery) or SM_Die("Database error adding email log entry: " .mysqli_error($GLOBALS['dbConnect']) . ". Query: $sqlquery", 'Unable to add email log entry - sorry!');
	mysql_logout();
}

/*
	DeAlias
	In 2018 all email addresses of the form recipient@espritgala.org were
	decommissioned, except those related to actually sending and troubleshooting
	email. The $mail_aliases table in .config.php maps recipient@espritgala.org
	addresses into real personal emails. This function returns the mapped
	address, if any, or the supplied address if no alias is found.
*/
function DeAlias($addr) {
	return array_key_exists(strtolower($addr), $GLOBALS['mail_aliases']) ? $GLOBALS['mail_aliases'][strtolower($addr)] : $addr;
} 

/*
	DeAliasString
	Replace any email addresses in the given string with the corresponding one from the
	$mail_aliases table in .config.php. This essentially extends the functionality of the
	DeAlias function above, and for the same reasons.
*/
function DeAliasString($str) {
	require_once ".auth/.config.php";
	$from_addrs = array_keys($GLOBALS['mail_aliases']);
	$to_addrs = array_values($GLOBALS['mail_aliases']);
	return str_replace($from_addrs, $to_addrs, $str);
}

/*
	get_account_balance
	Return the balance of an account given the confirmation number.
*/
function get_account_balance($conf) {
	$sql = 'SELECT sum(amount) balance
	FROM regpayment
	WHERE confirmation = "$conf"';
	$r = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die("Database error retrieving balance for account $conf: " . mysqli_error($GLOBALS['dbConnect']) . "Query: $sql", "Unable to retrieve account balance for $conf - sorry!");
	return $r['balance'];
}

/*
	get_transactions
	Return the transactions on an account given the confirmation number.
*/
function get_transactions($conf = null) {

	/*	Gather postings into array */

	if ($conf == null) {	//	... if there are any
		return array();		//	Otherwise return empty array
	}
	mysql_login('Read-only');
	$sqlcmd = "SELECT *
	FROM regpayment
	WHERE confirmation=$conf
	ORDER BY timestamp";
	$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": get_transactions didn't work. Query=$sqlcmd");
// 
// 	print $sql;
// 
	$trans = array();
	while ($row = mysqli_fetch_assoc($result)) {
		$trans[] = $row;
	}
	return $trans;
}

/*
	SM_Die
	Enhances the die() function to log the name of the calling function, line number and a diagnostic messsage to a file, then display a user-friendly error message to the user.
*/
function SM_Die($diagnostic_message, $friendly_message) {
	$bt = debug_backtrace(0, 3)[0];	//	Only 3 levels required
	$dm_location = strftime('%F %T'). ": {$bt['file']}:{$bt['function']}/{$bt['line']}";
	error_log("$dm_location: $diagnostic_message\n", 3, 'error_log_local');
	$dm_url = rawurlencode($dm_location);
	die("<span style=\"color: red; font-weight: bold\">$friendly_message</span><span onclick=\"alert(decodeURIComponent('$dm_url'))\">[Details]</span>");	
}
	
/*
	Other Utilities
*/
function array_map_recursive($callback, $array) {
	foreach ($array as $key => $value) {
		if (is_array($array[$key])) {
			$array[$key] = array_map_recursive($callback, $array[$key]);
		}
		else {
			$array[$key] = @call_user_func($callback, $GLOBALS['dbConnect'], $array[$key]);
		}
	}
	return $array;
}

?>