<?php	
/*
 * PHP QR Code encoder
 *
 * Exemplatory usage
 *
 * PHP QR Code is distributed under LGPL 3
 * Copyright (C) 2010 Dominik Dzienia <deltalab at poczta dot fm>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */
	
//	echo "<h1>PHP QR Code</h1><hr/>";

/* connect to our database so we can pull out the required information */

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";

require_once 'mysql_utilities.php';

$myDb = mysql_login();
	
$base_url= dirname(__FILE__);
// echo $base_url;

	//set it to writable location, a place for temp generated PNG files
	$PNG_TEMP_DIR = dirname(__FILE__).DIRECTORY_SEPARATOR.'qrtemp'.DIRECTORY_SEPARATOR;
	
	//html PNG location prefixes.
	// Local directory for use inside registration
	$PNG_WEB_DIR = '../qrcode/';
	// Externally readable directory for access without secure password
	$PNG_EXPORT_DIR = '/Library/WebServer/Secure/esprit/qrcode/';

	include "qrlib.php";	
	
	//ofcourse we need rights to create temp dir
	if (!file_exists($PNG_TEMP_DIR))
		mkdir($PNG_TEMP_DIR);
	
	
	if (isset($_REQUEST['id'])) {
		$filename = $PNG_WEB_DIR.'presentation'.$_REQUEST['id'].'.png';
	} else {
		$filename = $PNG_WEB_DIR.'test.png';
	}
// echo $filename;

/* Extract presentation details from database based on id */

	$cid = $_REQUEST['id'];
	$sql = "SELECT r.firstname firstname,r.lastname lastname,
	s.resourceroom resourceroom, s.resourcedate resourcedate,
	s.resourceduration resourceduration, s.bus_name bus_name
	FROM reg r
	INNER JOIN regpresenter s ON s.id=$cid
	WHERE s.confirmation_no=r.confirmation_no";
	$result = mysqli_query($dbConnect, $sql) or die(__FILE__.': Database error on main query: '.mysqli_error($dbConnect).'. Query='.$sql);
	$row = mysqli_fetch_array($result);
	foreach ($row as $key => $val) {
		$v[$key] = stripslashes($val);
	}
//	print_r($v);
	$room = $v['resourceroom'];
	$name = $v['bus_name'];
	$presenter = $v['firstname'] . ' ' . $v['lastname'];
	$dstart = new DateTime($v['resourcedate']);
	$dend = new DateTime($v['resourcedate']);
	$dalarm = new DateTime($v['resourcedate']);
	$stime = ($dstart->format('YmdHisT'));
	
	date_add($dend, date_interval_create_from_date_string("{$v['resourceduration']} minutes"));
	$etime = ($dend->format('YmdHisT'));

	date_sub($dalarm, date_interval_create_from_date_string('20 minutes'));
	$atime = ($dalarm->format('YmdHisT'));



//	echo "\$stime = $stime; \$etime = $etime; \$atime = $atime;\n";
	$dataline="BEGIN:VCALENDAR\nVERSION:2.0\nBEGIN:VEVENT\nDTSTAMP:20120323\nBEGIN:VALARM\nACTION:AUDIO\nTRIGGER:$atime\nREPEAT:4\nDURATION:PT1H\nEND:VALARM\nDTSTART:$stime\nDTEND:$etime\nSUMMARY:$name, $presenter\nLOCATION:$room\nEND:VEVENT\nEND:VCALENDAR\n";
//	echo "$dataline<br />";
	//processing form input
	//remember to sanitize user input in real-life solution !!!
	$errorCorrectionLevel = 'L';
	if (isset($_REQUEST['level']) && in_array($_REQUEST['level'], array('L','M','Q','H')))
		$errorCorrectionLevel = $_REQUEST['level'];	

	$matrixPointSize = 4;
	if (isset($_REQUEST['size']))
		$matrixPointSize = min(max((int)$_REQUEST['size'], 1), 10);


	if (isset($dataline)) { 
	
		//it's very important!
		if (trim($dataline) == '')
			die('data cannot be empty! <a href="?">back</a>');
			
		// user data
		$tempfilename = $PNG_TEMP_DIR.'test'.md5($dataline.'|'.$errorCorrectionLevel.'|'.$matrixPointSize).'.png';
		QRcode::png($dataline, $filename, $errorCorrectionLevel, $matrixPointSize, 2);	
		
	} else {	
	
		//default data
		echo 'You can provide data in GET parameter: <a href="?data=like_that">like that</a><hr/>';	
		QRcode::png('PHP QR Code :)', $filename, $errorCorrectionLevel, $matrixPointSize, 2);	
		
	}
	
	/*	Now create a file based on the date, time and location and place it
		outside the ssecure website. This will make creating fixed external
		links easier.
	*/
	$export_filename = "$PNG_EXPORT_DIR$stime$room" . ".png";
	$export_filename = str_replace(' ','', $export_filename);	// remove spaces
//	echo "\$filename=$filename; \$export_filename=$export_filename";
	copy($filename, $export_filename);
		
if ($_REQUEST['echo'] == 'echo') {
	echo '<img src="'.$filename.'" />';  
}
?>