<?php
/*
	Check attendwith. This is called from the initial reg/.index.php page tabs where users are asked to enter email and confirmation number when registering an additional person. It is attached to the confirmation number field and requires the preceding email field to be supplied, with an ID of "testemail". Both are checked according to the following conditions, which are supplied in the individual validate[ajax[xxx]] parameters for each use.
	
	The validation engine calls this function with the following:
	extraDataDynamic:	always the email address field "testemail"
	extraData:	type	is the form type being checked
				list	is a parenthesised, comma_separated list of form types
						this can be associated with
				limit	"1" if only one "type" can attend with someone on that
						list; if omitted, no limit.
	If the email/confirmation pair is already registered with one of the list types and the limit condition (if any) is met, the validation succeeds; otherwise it fails. It also fails if the email given is blacklisted.
*/

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'blacklist.php';
require_once 'mysql_utilities.php';

/* Get value to check */
$validateValue=trim($_REQUEST['fieldValue']);
$validateId=$_REQUEST['fieldId'];
$form_type = $_REQUEST['type'];
$attend_with = $_REQUEST['With__relto_email'];
$allowable_list = $_REQUEST['list'];
$limit = (isset($_REQUEST['limit']) ? $_REQUEST['limit'] : false);	// number of for only one allowed (SO or assistant); omitted if no limit

/*	Create error messages for each type of form */
$err = array(
	'Add_Family' => array(
		'onlist' => 'This must be the email and confirmation number of a suitable attendee who must be already registered.',
		'already_related' => 'Another attendee is already related to this one.'
		),
	'SO' => array(
		'onlist' => 'This must be the email and confirmation number of a suitable attendee who must be already registered.',
		'already_related' => 'You cannot add another SO to this person.'
		),
	'Assistant' => array(
		'onlist' => 'This must be the email and confirmation number of your Presenter or Vendor who must be already registered.',
		'already_related' => 'This Presenter or Vendor already has an Assistant registered.'
		),
	'Guest' => array(
		'onlist' => 'This must be the email and confirmation number of your sponsoring Committee Member, who must be already registered.',
		'already_related' => 'This person is already sponsoring the maximum number of guests.'
		),
	'Observer' => array(
		'onlist' => 'This must be the email and confirmation number of your sponsoring Committee Member, who must be already registered.',
		'already_related' => 'This person is already sponsoring the maximum number of guests.'
		),
	'Volunteer' => array(
		'onlist' => 'This must be the email and confirmation number of your sponsoring Committee Member, who must be already registered.',
		'already_related' => 'This person is already sponsoring the maximum number of volunteers.'
		)
	);
	
mysql_login('Read-only');

/*	Check to see if supplied email and confirmation number is not blacklisted, is already registered (it must be), AND isn't already over limit. */

if (blacklist($attend_with, $mysqlLink)) {	/*	Blacklisted? */
	echo json_encode(array($validateId, false,'Registration DECLINED. Please contact registrar@espritconf.com for assistance.'));

} else {

	$sqlcmd = "SELECT email found_email
	FROM reg
	WHERE email=\"$attend_with\"
		AND confirmation_no=\"$validateValue\"
		AND form_type IN $allowable_list";

	$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": didn't work");

	$count = @mysqli_num_rows($result);
	$row = mysqli_fetch_assoc($result);
	$found_email = $row['found_email'];		//	this is who we're
														//	trying to relate to

	/*	Do we have a matching record? */
	if ($count == 0) {	//	No matching registration, fail
		echo json_encode(array($validateId, false, $err[$form_type]['onlist']));
	} else {	//	Matching registration, how many related records are there?
		if ($limit === false) {	//	Omitted, we don't care.
			echo json_encode(array($validateId, true,''));
		} else {	//	Limit specified, have we exceeded it?
			$sqlcmd = "SELECT relto_email
			FROM reg
			WHERE relto_email=\"$found_email\"
				AND form_type=\"$form_type\"";

			$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": didn't work");
			$count = @mysqli_num_rows($result);

			if ($count >= $limit) {	//	Yes, fail. We can't add another
				echo json_encode(array($validateId, false,
			 $err[$form_type]['already_related']));
			} else {	//	Still within limit, ok to add another
				echo json_encode(array($validateId, true, ''));
			}
		}
	}
}
?>
