<?php
/*
	This validator checks the supplied email address to make sure it is
	registered as one of the provided form types. The acceptable form list is in
	the parameter "c" (from URL). c can be a comma-separated list of acceptable
	form types.
	
	It also checks against the blacklist. it returns success only if the email
	is not blacklisted and is registered as one of the provided types.
*/

/* Get value to check */
$validateValueUC=strtoupper(trim($_REQUEST['fieldValue']));
$validateId=$_REQUEST['fieldId'];
$list_to_check = $_REQUEST['c'];

$validateSuccess= "";

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'blacklist.php';
require_once 'mysql_utilities.php';

mysql_login('Read-only');

/*	Check to see if on blacklist */
/*	Following SELECT handles wildcard "*" in checklist by replacing them with MySQL's "%" wildcard */
$sqlcmd = "SELECT email, category
FROM regcontrol
WHERE \"$validateValueUC\" LIKE (REPLACE(UPPER(TRIM(email)), '*', '%'))
	AND category LIKE \"%Blacklist%\"";

$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": didn't work");

$blacklist = (@mysqli_num_rows($result) != 0);	//	Found match on blacklist?

if ($blacklist) {	//	Blacklisted. Return failure with blacklist message.
	$validateError= "Registration DECLINED. Please contact registrar@espritconf.com for assistance.";
	$sucess = false;
} else {		//	Not blacklisted, do further checks.
				//	Is this email already registered as one of the specified
				//	form types? (We don't care what form type is being
				//	registered now)

	$sqlcmd = "SELECT email, form_type
	FROM reg
	WHERE \"$validateValueUC\" = UPPER(TRIM(email))
		AND (LOCATE(TRIM(form_type),\"$list_to_check\") > 0)";

	$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": didn't work");

	$not_found = (@mysqli_num_rows($result) == 0);	//	if no matching record is
												//	found, not registered on any
												//	of the required form types
	if ($not_found) {	//	
		if (strpos($list_to_check, ',') > 0) {	//	If there's more than one
												//	type of acceptable form,
												//	don't list all.
			$list_to_check = 'eligible participant';
		}
		$validateError= "This must be the email of an already-registered $list_to_check.";
		$success= false;
	} else {	//	Made it through all the checks
		$validateError = '';
		$success = true;
	}	
}

/* Compile result array */
$arrayToJs = array();
$arrayToJs[0] = $validateId;
$arrayToJs[1] = $success;	//	Return success or failure
$arrayToJs[2] = $validateError;
echo json_encode($arrayToJs);				// Return array

?>