<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'regpackages p';
$db['tbnoalias'] = 'regpackages';

global $opts;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['pkg_type'] = [
		'heading' => "Pkg Type",
		'table' => 'p',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedlabels' => ['Full Rate', 'Single Day', 'Special Rate', 'Online'],
		'allowedvalues' => ['Full Rate', 'Single Day', 'Special Rate', 'Online'],
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_name'] = [
		'heading' => "Pkg Name",
		'table' => 'p',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_form_type'] = [
		'heading' => "Form Type",
		'table' => 'p',
		'display' => true,
		'width' => '10%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_tier'] = [
		'heading' => "Tier",
		'table' => 'p',
		'display' => true,
		'width' => '5%',
		'arrayedit' => true,
		'widget' => 'menu',
		'allowedvalues' => [1, 2, 3, 4, 5, 6, 7, 8],
		'allowedlabels' => [1, 2, 3, 4, 5, 6, 7, 8],
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_code'] = [
		'heading' => "Code",
		'table' => 'p',
		'display' => true,
		'width' => '5%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_rate'] = [
		'heading' => "Rate",
		'table' => 'p',
		'display' => true,
		'width' => '5%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['tax'] = [
		'heading' => "Tax",
		'table' => 'p',
		'display' => true,
		'width' => '5%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_discountable'] = [
		'heading' => "Disc",
		'long_heading' => "Discountable?",
		'table' => 'p',
		'fieldgroup' => '*',
		'filter' => ""];
$fields['pkg_days1'] = [
		'heading' => "S1",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_daym'] = [
		'heading' => "Mo",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_dayt'] = [
		'heading' => "Tu",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_dayw'] = [
		'heading' => "W",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_dayr'] = [
		'heading' => "Th",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_dayf'] = [
		'heading' => "Fr",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_daya'] = [
		'heading' => "Sa",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_days2'] = [
		'heading' => "S2",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_mealfb'] = [
		'heading' => "Fr B",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_mealfl'] = [
		'heading' => "Fr L",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_mealfd'] = [
		'heading' => "Fr D",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_mealsl'] = [
		'heading' => "Sa L",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_mealsd'] = [
		'heading' => "Sa D",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_mealub'] = [
		'heading' => "Su B",
		'table' => 'p',
		'display' => true,
		'width' => '3%',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_meal_selectable'] = [
		'heading' => "Sel. Mls?",
		'long_heading' => "Seletable Meals?",
		'table' => 'p',
		'display' => true,
		'width' => '5%',
		'widget' => 'menu',
		'allowablelabels' => ['Yes', 'No'],
		'allowablevalues' => ['1', '0'],
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_notes'] = [
		'heading' => "Notes",
		'table' => 'p',
		'display' => true,
		'width' => '10%',
// 		'widget' => 'ckeditor',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_readmore'] = [
		'heading' => "Read More",
		'table' => 'p',
//		'display' => true,
		'width' => '10%',
//		'arrayedit' => true,
//		'widget' => 'ckeditor',
		'fieldgroup' => '*, Master',
		'search_more' => true,
		'filter' => ""];
$fields['pkg_computation_notes'] = [
		'heading' => "Comments",
		'table' => 'p',
		'display' => true,
		'width' => '10%',
		'widget' => 'ckeditor',
		'arrayedit' => true,
		'fieldgroup' => '*, Master',
		'filter' => ""];
$fields['pkg_created'] = [
		'heading' => "Created",
		'table' => 'p',
		'display' => true,
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['pkg_updated'] = [
		'heading' => "Updated",
		'table' => 'p',
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'search_more' => true,
		'width' => '10%',
		'fieldgroup' => 'Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['pkg_available'] = [
		'heading' => "Available",
		'table' => 'p',
		'display' => true,
		'search_more' => true,
		'arrayedit' => true,
		'widget' => 'menu',
		'notallowedvalues' => ['1', '0'],
		'allowedlabels' => ['Yes', 'No'],
		'copyValue' => 'Yes',
		'width' => '10%',
		'fieldgroup' => '*, Master, Detail',	//	No copy to new
		'filter' => ""];
$fields['id'] = [
'heading' => 'Entry number',
		'primarykey' => true,
		'table' => 'p',
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];

/* End of Field definitions. */

/* Field group definitions */

$tpl['fieldgroups'] = [
/*	'Blank' => ['label' => '>',
		'url' => 'blank.php'], */
	'Master' => ['label'=>'Master',
		'url' =>''],
	'Detail' => ['label' => 'Details',
		'url' => 'taburl.php?template=package_detail.tpl',
		'authgroup' => ['Admin']],
	'AddNew' => ['label' => 'Copy',
		'url' => 'add.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
	],
	'Logs' => ['label' => 'Log Entries',
		'url' => "../log-list.php?tbname={$db['tbnoalias']}",
		'width' => 1500,
		'height' => 800,
		'authgroup' => ['Admin']],
	'DeleteThis' => ['label' => 'Delete',
		'url' => 'delete.php',
		'authgroup' => ['Admin'],
		'scroll' => 'No'	//	Prevent scrolling to this screen
		]
];

?>