<?php
/*
	This file adds a payment to the regpayment database.
	It also increments the meal quotas on the registration records if meals are
	being added (transtype='Meals').
*/

$confirmation_no = $_REQUEST['confirmation'];
$username = $_REQUEST['username'];
$authgroup = $_REQUEST['authgroup'];
global $mealnames;	//	Pick up meal stuff, including enabled flags (e.g.
					//	Veterans' Breakfast)
$meal1enabled = $mealnames['meal1']['enabled'];
define('QUADODO_IN_SYSTEM', true);

require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/.auth/.config.php";
require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/mysql_utilities.php";
mysql_login('Normal');

$db['tb'] = 'regpayment';

header("Location: payment-list.php?confirmation=$confirmation_no&username=$username&authgroup=$authgroup");

print '<link href="css/styles.css" rel="stylesheet" type="text/css" media="all">';
/*	Sanitise input */	
$fee = $_REQUEST['fee'];
$reference = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['reference']);

$source = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['source']);
$transtype = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['transtype']);
$quantity = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['quantity']);
$addon_key = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['addon_key']);
$addon_pointer = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['addon_pointer']);
$amount = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['amount']);
$tax = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['tax']);
$pnotes = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['pnotes']);
$ratepkg = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['ratepkg']);
$addon_desc_link = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['addon_desc_link']);
$timestampreg = mysqli_real_escape_string($GLOBALS['dbConnect'], $_REQUEST['timestampreg']);

$timestamp = date('Y-m-d H:i:s');	// for this posting

if (empty($confirmation_no)) {
	SM_Die('Missing confirmation no. Cannot add an entry.', 'Internal error. Cannot post transaction - sorry!');
} else {
	if ((0+$amount) <= 0) {
		$r = 'NULL';	// no receipt number except for payments
	} else {
		// create next available receipt no.
		$sql = "SELECT max(receipt_no) r
		FROM {$db['db']}.{$db['tb']}";
		$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to generate receipt number - sorry!');
		$row = mysqli_fetch_array($result);
		
		$r = $row['r']+1;	// increment receipt number past highest existing.
							// Can't set field to auto-increment as we already
							// have id as auto-increment
	}
	if ($addon_pointer == '') {		//	Not a meal, doesn't have addon_pointer
		$addon_pointer = 'NULL';
	}
	if ($addon_pointer == '*') {	//	Wildcard for multiple meals
		$addon_pointer = "'*'";
	}
	$sql = "INSERT INTO {$db['db']}.{$db['tb']} (timestamp, username, authgroup, transtype, reference, amount, tax, source, pnotes, confirmation, receipt_no, addon_key, addon_pointer, quantity) VALUES ('$timestamp', '$username', '$authgroup', '$transtype', '$reference', $amount, $tax, '$source', '$pnotes', $confirmation_no, $r, $addon_key, $addon_pointer, $quantity);";
	$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error processing payment posting: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to automatically post payment - sorry!');
	
	$confirmation = $row['confirmation'];
	
	/*
	Now update meal counts for badges if any extra meals were purchased.
	We use the addon_pointer which indicates the meal field to
	increment.
*/
if ($transtype == 'Meals') {	//	Meal?
	$m = $addon_pointer;		//	Which one?
// 	print "Updating meal count for meal no. $m";

	if ($m === "'*'") {	//	All of them.
		$i1 = $meal1enabled ? 1: 2;
		for ($i = $i1; $i <= 6; $i++) {
			$updateclause .= "meal{$i}=meal{$i}+$quantity,meal{$i}checked=meal{$i}checked+$quantity,";
		}
		$updateclause = rtrim($updateclause, ',');
	} else {
		$updateclause .= "meal$m=meal$m+$quantity,meal{$m}checked=meal{$m}checked+$quantity";
	}

	$sql = "UPDATE reg SET $updateclause WHERE confirmation_no=$reference";
// 	print '<h4>' . __FUNCTION__ . ": updating meal count; \$sql=$sql </h4>";
	$rmeal = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error while updating meal counts: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to automatically update meal counts - sorry!');
}

	$sql = "SELECT sum(amount) balance
	FROM {$db['db']}.{$db['tb']}
	WHERE confirmation=$confirmation_no";
	$b_row = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error while trying to compute account balance: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to recompute account balance - sorry!');
	$b = mysqli_fetch_assoc($b_row);
/*
	If zero balance, update reg_status to say paid - but only if staatus is
	already Paid or Pre-registered; i.e. ,exclude Cancelled people.
*/
	if ($b['balance'] == 0) {
		$sql = "UPDATE reg SET reg_status=\"Paid\" WHERE confirmation_no=$confirmation_no AND reg_status in ('Paid', 'Pre-registered')";
		$b = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error while trying to update status to Paid: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to update status to Paid - sorry!');
	}

	// Add log file entry

	$sql_escaped = mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
	Make_Log_Entry($GLOBALS['dbConnect'], "TRANSACTION POSTED: $sql_escaped");
	mysql_logout();	//	Disconnect from database
}
?>