<?php
/*
	Smarty plugin
	-------------------------------------------------------------
	File:		function.helpbutton.php
	Author:		Stephanie Mitchell
	Date:		13 November, 2010
	Type:		function
	Name:		helpbutton
	Purpose:	draws a help button which links to a specified
				text file
	Parameters:	fieldname	will look up the help filename from
							filelist.php for the given field.
				filename	will link to this filename. Don't
							use fieldname and filename together,
							although one or the other is required.
				appname		application name; specifies the application
							folder where the fieldnames are located.
				buttonsize	Optional: pixel dimensions of the
							help button image. If omitted the
							actual image dimensions are used.
				width		the width of the Highslide popup in
							which the help file is displayed.
							Optional: defaults to 450 pixels.
				height		the height of the Highslide popup in
							which the help file is displayed.
							Optional: detaults to 300 pixels.
				group		Optional: name of help button group.
							Displayed help files for buttons with
							the same group name link together
							with "<<Prev" and "Next >>" buttons.
 */

function smarty_function_helpbutton($params, $template)
{
	$appname = $params['appname'] ?? 'includes';
	include "$appname/fieldlist.php";
	$field = $params['fieldname'] ?? false;
	$file = $params['filename'] ?? false;
	$url='';
	$width = $params['width'] ?? 800;
	$height = $params['height'] ?? 500;
	$group = $params['group'] ?? $field;
	$addtext = $params['addtext'] ?? '';
	$b = $params['buttonsize'] ?? '1.2em';
	
	if ($field) {	//	Were we given a fieldname?
		$helpfile = $fields[$field]['helpfile'];
	} elseif ($file) {	//	Were we given a specific filename?
		$helpfile = $file;
	}	//	Neither; leave unset
	
	if (isset($helpfile)) {
		/* Set up default sizes for grouping and button size */
		$url = "<a href=\"/$helpfile\" onclick=\"return hs.htmlExpand(this, { headingText: '$addtext',objectType: 'iframe', width: $width, height: $height })\"><img src=\"/images/sm_help.png\" style=\"height:$b\" id=\"hshelpbutton\" />$addtext</a>";
	}
	return $url;
}
?>