<?php
/*
	Sets up and displays the "Copy to Current" tab for the Scholarships
	susbystem. Only appears in the scholarshipsall screen (All Years
	Scholarships).
	
	Stephanie Mitchell, 4 April, 2023
*/
/*
	See if logged in via Quadodo
*/

// 	ini_set('display_startup_errors',1);
// 	ini_set('display_errors',1);
	error_reporting(-1);		//	All errors
global $tpl;
define('QUADODO_IN_SYSTEM', true);
$dirname = dirname(__FILE__);
$basename = dirname($dirname);

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once "mysql_utilities.php";
require_once "header.php";
require_once ".config.php";
require_once "setup.php";
require_once "fieldlist.php";
require_once "template_options.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
	header('Location: ../qls/login.php');
	exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$group = $_REQUEST['group'];
$all_years = $_REQUEST['all_years'] ?? '';
mysql_login('Normal');



$mydata = get_mysql_fields('Master', $fields, $primarykeyfieldname, $primarykeyfieldvalue, 'scholappall s', $all_years);
print_r($mydata); 
die('Here');

/*	Capture old confirmation number for use in updates */

$oldconfirmation = $mydata['confirmation_no'];

/*
	Force a distinctive group name to identify the new record
*/

$mydata['preferredfirst'] .= ' (NEW)';

// insert the new record and get the new auto_increment id
$sql = "INSERT INTO scholappall (`{$primarykeyfieldname}`) VALUES (NULL)";
$result = mysqli_query($GLOBALS['dbConnect'], $sql) or SM_Die('Database error on insert while copying scholarship to current year: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql, 'Unable to insert new record while copying scholarship to current year - sorry!');

$newid = mysqli_insert_id($GLOBALS['dbConnect']);
$mydata[$primarykeyfieldname] = $newid;

/*
	Generate the query to update the new record with the previous values.
*/

$sql = "UPDATE scholappall SET ";
foreach ($mydata as $key => $value) {
	if ($key != $primarykeyfieldname) {
		if (isset($fields[$key]['copyValue'])) {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$fields[$key]['copyValue']).'", ';
		} else {
			$sql .= '`'.$key.'` = "'.str_replace('"','\"',$value).'", ';
		}
	}
} 

$sql = rtrim($sql, ', '); // lop off extra trailing comma
$sql .= " WHERE {$primarykeyfieldname}={$newid}";
$sql_escaped = $sql; // mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
$result = mysqli_query($GLOBALS['dbConnect'], $sql_escaped) or SM_Die('Database error on update while copying attendee to current year: ' . mysqli_error($GLOBALS['dbConnect']) . ". Query=$sql_escaped", 'Unable to update information while copying attendee to current year - sorry!');

Make_Log_Entry($GLOBALS['dbConnect'], "NEW SCHOLARSHIP ADDED VIA COPY TO CURRENT: $sql_escaped");

$e = new Smarty_Esprit;
$e->addPluginsDir("{$_SERVER['DOCUMENT_ROOT']}/plugins/");
$e->registerPlugin("modifier","ss", "stripslashes");
$e->assign('mydata',$mydata);
// print_r($tpl);
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/$dirname/templates/");
$e->display('basic_detail.tpl');
?>
