<?php
/*
	Sets up and displays the "Delete" tab for the Scholarships susbystem.
	
	Stephanie Mitchell, 7 April, 2023
*/
/*
	See if logged in via Quadodo
*/
global $tpl;
define('QUADODO_IN_SYSTEM', true);
$dirname = dirname(__FILE__);
$basename = dirname($dirname);

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'mysql_utilities.php';

require_once "header.php";
require_once ".config.php";
require_once "setup.php";
require_once "fieldlist.php";
require_once "template_options.php";
$tpl['authgroup'] = $qls->group_id_to_name($qls->user_info['group_id']);
$tpl['username'] = $qls->user_info['username'];
if ($tpl['username'] == '') {
header('Location: /qls/login.php');
exit;
}

$primarykeyfieldvalue = $_REQUEST['pkfv'];
$primarykeyfieldname = $_REQUEST['pkfn'];
$group = $_REQUEST['group'];

mysql_login('Normal');

$mydata = get_mysql_fields($group, $fields, $primarykeyfieldname, $primarykeyfieldvalue, $db['tb']);
delete_mysql_record('scholapp', "entrynum", $mydata['entrynum']);

$sql_escaped =  mysqli_real_escape_string($GLOBALS['dbConnect'], $sql);
Make_Log_Entry($GLOBALS['dbConnect'], "SCHOLARSHIP APPLICATION DELETED: $sql_escaped");

$e = new Smarty_Esprit;
$e->registerPlugin("modifier","ss", "stripslashes");
$e->assign('mydata',$mydata);
$e->assign('record_deleted',true);	//	Overlay with record_deleted stylesheet
// print_r($tpl);
$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
$e->addTemplateDir("$dirname/templates");
$e->display('application_detail.tpl');

?>
