<?php
/*
	Esprit Online Registration System
	Stephanie Mitchell, 23 November, 2017
	
	This  file contains the fieldlist details for SM_SQLEdit.
	It lists all the fields in the relevant database along with parameters
	that control their display and other characteristics.
	
	Parameters are described in detail in /manager/help/fieldlistdoc.php.
	
*/
/*	Protect from non-logged in users */
defined('QUADODO_IN_SYSTEM') or header('HTTP/1.1 403 Forbidden')&die('Restricted access');

/* MySQL table names */

$db['tb'] = 'reglog';	// log file
global $opts;
$opts['join_clause'] = '';

/* Field definitions start here */

$fields['time'] = [
		'heading' => "Timestamp",
		'display' => true,
		'css' => 'font-size:80%',
		'date_format' => '%d%b%Y<br />%T',
		'fieldgroup' => 'Master, *',
		'width' => '15%',
		'filter' => ""];
$fields['user'] = [
		'heading' => "User",
		'display' => true,
		'fieldgroup' => 'Master, *',
		'width' => '15%',
		'filter' => ""];
$fields['entry'] = [
		'heading' => "Log Entry",
		'display' => true,
		'fieldgroup' => 'Master, *',
		'width' => '50%',
		'truncate_display' => 120,	//	Maximum chars to display in listing
		'filter' => ""];
$fields['id'] = [
		'heading' => 'ID',
		'primarykey' => true,
		'search_more' => true,
		'fieldgroup' => '*',
		'filter' => ""];

/* Field definitions end here. */

/* Field group definitions */

$tpl['fieldgroups'] = [
	'Master' => ['label'=>'Read-only', 'url' =>''],
	'Detail' => ['label' => 'Details',
		'url' => 'taburl.php?template=syslog_detail.tpl',
		'authgroup' => ['Admin']]
];

?>