{* Smarty template for displaying a field in a detail screen. Place it inside <tr> tags *}
{* Parameters:
	$tname		table name
	$fname		field name
	$dname		field label (overrides heading or long_heading field from fieldlist.php
				if not null)
	$labelhelp	field help (explanatory note below field label)
	$pkey		primary key field name
	$ftype		field display type
	$labelcss	additional CSS for label (e.g. background colour)
	$fieldcss	additional CSS for value section (e.g. background, bold)
*}
	<td class="label" width="15%" {if $labelcss ne ''}style="{$labelcss}"{/if}><span 
	{*	Generate additional help text in tooltip. If labelhelp parameter is supplied, use
		it. Otherwise use labelhelp field from fieldlist.php if any. *}
	{if $labelhelp ne ''} title="{$labelhelp}"
	{elseif $tpl.fields.$fname.labelhelp ne null} title="{$tpl.fields.$fname.labelhelp}"{/if}>
	{*	Generate field label. If dname is supplied, use that. Otherwise if field's
		long_heading is supplied in fieldlist.php file, use that. Failing that, use
		field's heading from fieldlist.php. *}
	{if $dname ne ''}{$dname}
	{elseif $tpl.fields.$fname.long_heading ne ''}{$tpl.fields.$fname.long_heading}
	{else}{$tpl.fields.$fname.heading}</span></td>
	{/if}
	{*	Generate actual field. *}
	<td>{if $ftype eq 'display'}<span class="value" style={"$fieldcss"}>{$mydata.$fname}</span>
	{else}<span class="{$ftype}" style="{$fieldcss}" id="{$tname}.{$fname}.{$mydata.$pkey}.{$pkey}">{$mydata.$fname}</span>{/if}
</td>