{* Smarty *}
{*	smse_recordlist.tpl
	Smarty template that produces a list of records using Highslide. The
	list includes the fields that have 'Master' in their fieldgroup parameter in
	fieldlist.php, with a dropdown menu for displaying further detail.
	
	In this version, double-clicking anywhere on a row opens a Highslide window with the
	initial detail displayed. There is no action button any more.
	
	This works by listening for a double-click event on any table row. The first <td> in
	the row contains <a> elements to open all the highslide windows for each tab. A
	double-click on a row triggers a click on the frst <a>, thus opening its Highslide
	window. We use a double-click to make it more deliberate and to prevent the click
	event from bubbling up and causing recursion.
*}
<!--smse_recordlist.tpl - BEGIN-->

<script>
	$(function() {
		$( ".tabs" ).tabs({
			ajaxOptions: {
				cache: false,
				/* async: false, */
				error: function( xhr, status, index, anchor ) {
					$( anchor.hash ).html(
						"<span class=\"warning\">Couldn't show this tab. There may be a problem with it or it may not have been written yet.</span>" );
				}
			}
		} );
		$("#smse_tablebody tr").dblclick(function() {
				$(this).find("a").first().click();
		} );
	} );
</script>
{* Generate heading "row" *}
<table>
<thead id="smse_tablehead">
<tr>
{foreach $fields as $thisfield}
	{if strpos(".{$thisfield.fieldgroup}", 'Master') > 0}
		<td{if $thisfield.width gt 0} width="{$thisfield.width}"{/if}>
		{if $thisfield@key == $sort_field}
			{if $sort_order == " DESC"}
				<b>{$thisfield.heading}<img src="/images/sm_desc.png"></b>
			{else}
				<b>{$thisfield.heading}<img src="/images/sm_asc.png"></b>
			{/if}
		{else}
			<b>{$thisfield.heading}</b>
		{/if}
		</td>
	{/if}
{/foreach}
<td>&nbsp;</td>
</tr>
</thead>
<tbody id="smse_tablebody"><!-- Double-clicks are listened for via jQuery-->
{section name=sec1 loop=$data}
{$mydata=$data[sec1]}
<tr style="cursor: grab" class="{$mydata.action}history">
<td style="display:none"><!-- URLs for Highslide tabs -->
{foreach $tpl.fieldgroups as $thisgroup} {* build tabs *}
	{if $thisgroup@key ne 'Master' and ($thisgroup.authgroup eq '' or in_array($tpl.authgroup, $thisgroup.authgroup))}
		{$url="href=\"{$thisgroup.url}{if strpos($thisgroup.url,'?')>0}&{else}?{/if}group={$thisgroup@key}&pkfn={$primarykeyfield}&pkfv={$mydata.$primarykeyfield}\" 
		onclick=\"return hs.htmlExpand(this, { objectType: 'iframe', slideshowGroup:'{$mydata.$primarykeyfield}and{$mydata.revision}'{if $thisgroup.width>0}, width: {$thisgroup.width}{/if}{if $thisgroup.height>0},height: {$thisgroup.height}{/if} } )\""}
	<a {$url}>{$thisgroup.label}</a>
	{/if}
{/foreach}
</td><!-- End of Highslide tab URL td -->
{foreach $fields as $thisfield} {* Build master field list *}
	{if strpos(".{$thisfield.fieldgroup}", 'Master') > 0}
	<td{if $thisfield.width gt 0} width="{$thisfield.width}"{/if}>{if $thisfield.truncate_display gt 0}{$mydata.{$thisfield@key}|truncate:$thisfield.truncate_display:"[more...]"}{else}{$mydata.{$thisfield@key}}{/if}&nbsp;</td>
	{/if}
{/foreach}
<td>&nbsp;</td>
</tr>
{/section}
</tbody>
</table>
</div>
<!--smse_recordlist.tpl - END-->
