{* Smarty template file for Payments by Date. *}
{section name=sec1 loop=$data}
{$mydata=$data[sec1]}
{if $smarty.section.sec1.first}
<table repeat_header=1>
<thead>
<tr class="row-head">
<td width="10%">Date</td>
<td width="10%">Name</td>
<td>Confirmation</td>
<td width="10%">Type</td>
<td>Reference</td>
<td>Source</td>
<td>Notes</td>
<td width="7%" class="right">Debit</td>
<td width="7%" class="right">Credit</td>
<td width="7%" class="right">Tax</td>
</tr>
</thead>
<tbody>
{$print_date=true}
{/if}

{if $mydata.dt eq '' and $mydata.id eq '' and $mydata.conf eq ''}
{* Grand total row. All rollup fields are null *}
{$print_date=false}
<tr class="row-grand">
<td></td>
<td colspan="6"><b>GRAND TOTAL</b></td>
{if $mydata.amt ge 0}
<td class="right"><b>{$mydata.amt}</b></td>
<td></td>
{else}
<td></td>
<td class="right red"><b>{$mydata.amt}</b></td>
{/if}
<td class="right"><b>{$mydata.tax}</b></td>
</tr>

{elseif $mydata.id eq '' and $mydata.conf eq ''}
{* Date total. conf and id fields are null *}
{$print_date=true}
<tr class="row-subtotal2">
<td></td>
<td colspan="6"><b>TOTAL FOR {$mydata.dt}</b><br /><br /></td>
{if $mydata.amt ge 0}
<td class="right"><b>{$mydata.amt}</b></td><td></td>
{else}
<td></td><td class="right red"><b>{$mydata.amt}</b></td>
{/if}
<td class="right"><b>{$mydata.tax}</b></td>
</tr>

{elseif $mydata.id eq ''}
{* User total. id field is null. *}
{$print_date=false}
<tr class="row-subtotal">
<td></td>
<td colspan="6"valign="top"><b>TOTAL FOR {$mydata.lname}, {$mydata.fname} </b></td>
{if $mydata.amt ge 0}
<td class="right"><b>{$mydata.amt}</b></td><td></td>
{else}
<td></td><td class="right red"><b>{$mydata.amt}</b></td>
{/if}
<td class="right"><b>{$mydata.tax}</b></td>
</tr>

{else}
{* Data line. Print it all. *}
<tr class="{cycle values="row-0, row-1"}">
<td>
{if $print_date eq true}<b>{$mydata.dt|date_format:"%Y-%m-%d"}{$print_date=false}</b>{/if}</td>
<td><a href="index.php?confirmation_no={$mydata.conf}&_report_name=Default"><strong>{$mydata.lname}, {$mydata.fname}</strong></td>
<td>{$mydata.conf}</td>
<td>{$mydata.ttype}</td>
<td>{$mydata.reference}</td>
<td>{$mydata.src}</td>
<td>{$mydata.pnotes}</td>
{if $mydata.amt ge 0}
<td class="right">{$mydata.amt}</td><td></td>
{else}
<td></td><td class="right red">{$mydata.amt}</td>
{/if}
<td class="right">{$mydata.tax}</td>
</tr>
{* End of format selection loop *}
{/if}
</tr>
{if $smarty.section.sec1.last}
<tr><td> </td></tr>
</tbody>
</table>
{/if}
{sectionelse} <h4>Nothing to report.</h4>
{/section}
