<?php
/*
	Esprit Registration System
	by Stephanie Mitchell
	Primary Attendee Registration Form
	8 May, 2015.
	Updated to include SO and Add. Family registrations on the same form.
*/

define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = (isset($_REQUEST['date']) ? $_REQUEST['date'] : 'now');
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}
$password = (isset($_REQUEST['password']) ? $_REQUEST['password'] : false);
$form_type = "Single";	//	MUST match one of the rate groups in config.php
						//	(Single, SO etc.)
require_once "classes.php";	//	Pull in everything
?>
<html>
<?php
	require_once "head.php";
?>
<body>
<?php
if ($check['preregistration_closed']) {
	print closed($form_type, $date_text['registration_closed']);
	exit;
}
if ($check['registration_not_yet_open']) {
	print notyetopen($form_type, $date_text['registration_open']);
	exit;
}
print masthead('Attendees');
?>
<div class="section">
	<div class="headerbar">Instructions</div>
	<ol>
		<li>This form is for registering attendees, their Significant Others and any additional family members. If you're not an Attendee (i.e. you're a Presenter, Vendor etc.) please <a href="/index.php">return to Registration Start</a> and select the appropriate form.</li>
		<li>Each person attending Esprit MUST BE REGISTERED. You can use this form to register yourself and optionally your SO and an additional family member.</li>
		<li> <span class="reqd reqdhilite">Fields highlighted like this</span> are required.</li>
		<li><span class="i">Note that pre-registering does not obligate you to pay or attend nor are you guaranteed a space at Esprit or any hotel.</span></li>
		<li>Click Submit at the bottom. Your official Registration Letter will arrive via email shortly.</li>
		<?php
		if ($today < $date['payment_deadline']) {
			print "<li>Our mailing address is:<br />
				<br /> $esprit_treasurer_address<br />
				<br />
				</li>";
		}?>
		<li> We urge you to refer to these Help buttons<?php print helpbutton('helpbuttonhelp.php');?> for lots of useful information and guidance.</li>
	</ol>
	<p class="tiny">All information is kept strictly confidential.</p>
</div>
<form action="../process.php" method="post" enctype="multipart/form-data" name="form1" id="formID">
<!-- Note time application was started -->
 <?php print '<input type="hidden" value="' . date("Y-m-d") . '" name="noupload[appstart]" testdata="no">';?>

<?php
print form_switches(array('Single', 'SO', 'Add_Family'));
print esprit_names(array('Single', 'SO', 'Add_Family'));
require_once "bill_contact.php";

/*
	Create the rate tables for each selected type.
*/
$rates = new ratetable;
print $rates->preamble($form_type);
print '<table width="100%">
	<tr>';
print '<td>' . $rates->table('reg', $form_type, 'You') . '</td>';
print '<td class="so">' . $rates->table('reg', 'SO', 'Your SO') . '</td>';
print '<td class="af">' . $rates->table('reg', 'Add_Family', 'Your Additional Family') . '</td>';
print '</tr></table>';
/*
	Create the scholarship application section.
*/

print '<table width="100%">';
print scholapp($check['scholarships_open'], $form_type);
print '</table>';
print $rates->postamble();

/*
	Add-ons
*/
print other_purchases($form_type);
	
/*
	Create the volunteer signup section.
*/
$volunteer = new volunteer;
print $volunteer->preamble($form_type);
print "<a onclick=\"$('.vo').toggle()\" > Click here</a> to see the opportunities we have for you!</p>";
print '<div class="vo">';
print '<table width="100%">
	<tr>';
print '<td>' . $volunteer->table('reg', $form_type, 'You') . '</td>';
print '<td class="so">' . $volunteer->table('reg', 'SO', 'Your SO') . '</td>';
print '<td class="af">' . $volunteer->table('reg', 'Add_Family', 'Your Additional Family') . '</td>';
print '</tr></table>';
print $volunteer->postamble();
print '</div>';

/*
	Gather the badge photo(s).
*/
$badge = new badgephoto;
print $badge->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $badge->table('reg', $form_type, 'You') . '</td>';
print '<td class="so">' . $badge->table('reg', 'SO', 'Your SO') . '</td>';
print '<td class="af">' . $badge->table('reg', 'Add_Family', 'Your Additional Family') . '</td>';
print '</tr></table>';
print $badge->postamble();	//	Postamble

/*
	Gather the vax certificates.
*/
$vaxcert = new vaxcertificate;
print $vaxcert->preamble($form_type);	//	Preamble
print '<table width="100%">
	<tr>';
print '<td>' . $vaxcert->table('reg', $form_type, 'You') . '</td>';
print '<td class="so">' . $vaxcert->table('reg', 'SO', 'Your SO') . '</td>';
print '<td class="af">' . $vaxcert->table('reg', 'Add_Family', 'Your Additional Family') . '</td>';
print '</tr></table>';
print $vaxcert->postamble();	//	Postamble

/*
	The fine print section
*/

require_once "fine_print.php";

?>
<div><!-- Hidden fields required by this form, plus form submit button -->	
	<input type="hidden" name="noupload[source_form_type]" testdata="no" id="source_form_type" value="Attendee" />
	<input type="hidden" name="password" id="password" value="<?php print $password;?>" />

	<input type="submit" id="postbut" name="Submit Pre-Registration" value="Submit Pre-Registration" />
</div>
</form>
</body>
</html>
