<?php
function closed($form_type, $open_date_text) {

	switch ($form_type) {
	case 'Committee_Full':
	case 'Committee_Partial':
		$result = "
		<span class=\"i\">Esprit</span> Online Registration is closed as of $open_date_text.</h2>
		<p>We do appreciate your interest and eagerness!</p>
		<p>If this is urgent, please contact Stephanie Mitchell for the unlock key.</p>
		<p><a href=\"../index.php\">[Return to Registration Start] </a><a href=\"https://www.espritgala.org\">[Return to Esprit Main Site]</a></p>
		";
		break;

	case 'Scholarship':
		global $check;
		$result = "
		<h2><span class=\"i\">Esprit</span> $esprit_year Scholarship Applications are Closed.</h2>
		Esprit $esprit_year Scholarship Applications closed on $open_date_text.
		<p>The Scholarship Committee is presently reviewing all the applications we have received. We will be notifying all applicants shortly.</p>
		<p>Please note: if you apply after the scholarship deadline your chances of being awarded a scholarship are very limited. Applications made after Esprit has started will not be granted.</p>
		<p>Thank you again for your interest in <i>Esprit</i>.</p>
		";
		if ($check['preregistration_open']) {
			$result .= '<p>You may still pre-register for Esprit; <a href="../index.php">[return to Registration start]</a>.</p>';
		}
		$result .= '<a href="https://www.espritgala.org">[Return to Esprit Main Site]</a></p>';
		break;

	default:
		$result = "
			<span class=\"i\">Esprit</span> Online Registration is closed as of $open_date_text.</h2>
		<p> We do appreciate your interest and eagerness!</p>
		<p>Thank you for your interest in the Esprit Convention. We hope to see you there!</p>
		<p><a href=\"../index.php\">[Return to Registration Start] </a><a href=\"https://www.espritgala.org\">[Return to Esprit Main Site]</a></p>
		";
	}
	return $result;
}

function notyetopen($form_type, $open_date_text) {

	switch ($form_type) {
	case 'Committee_Full':
	case 'Committee_Partial':
		$result = "
		<span class=\"i\">Esprit</span> Online Pre-Registration is not yet open!</h2>
		<p> We do appreciate your interest and eagerness! Online registration for the Esprit Committee opens on $open_date_text; please come back then.</p>
		<p>Thank you for your interest in the Esprit Convention. We hope to see you there!</p>
		<p><a href=\"../index.php\">[Return to Registration Start] </a><a href=\"https://www.espritgala.org\">[Return to Esprit Main Site]</a></p>
		";
	break;

	case 'Scholarship':
		$result =
	"<h2><span class=\"i\">Esprit</span> $esprit_year Scholarship Applications are not yet open!</h2>
	<p> We do appreciate your interest! 
		Scholarships for Esprit $esprit_year open on $open_date_text; please come back then.
	<p>Make sure you <a href=\"../index.php\">pre-register as soon as possible</a>, then come back to this form to apply for a scholarship.
	<p>You're going to have to provide a reference when you apply. While you're waiting, please give some thought to who you might ask.";
	$result .= helpbutton('reffaq.php', 'Please review this page for more information');
	$result .= " about why we need a reference and who can be one.
	<p>Thank you for your interest in the Esprit Convention. We hope to see you there!</p>
	<p><a href=\"../index.php\">[Return to Registration start]</a></p>
	<p><a href=\"https://www.espritgala.org\">[Return to Esprit Main Site]</a></p>
	";
	break;

	default:
	$result = 
	"<span class=\"i\">Esprit</span> Online Pre-Registration is not yet open!</h2>
	<p> We do appreciate your interest and eagerness! Online registration opens on $open_date_text; please come back then.</p>
	<p>Thank you for your interest in the Esprit Convention. We hope to see you there!</p>
	<p><a href=\"../index.php\">[Return to Registration Start] </a><a href=\"https://www.espritgala.org\">[Return to Esprit Main Site]</a></p>
	";
	}
	return $result;
}
?>
