<?php

/*	Generate form components for rate table.
*/
class ratetable {
function preamble($form_type) {

	/*	Generate preamble code */
	
	global $check, $date, $date_text, $package, $daynames;

	$result = '<div class="section"><div class="reqdhilite">';
	$result .= '<div class="headerbar">Attendance and Registration Fee</div>';
	if (ONLINE_ESPRIT == true) {
		$result .='<p class="bold">Esprit is ONLINE ONLY this year.<br />';
	} else {
		$result .= '<p class="bold">Please indicate days you\'re attending.<br />
		';
		$result .= '<table cellpadding="1" width="100%">';
		if ($check['refund_none']) {
			$result .= "<p class=\"bold\">The deadline for refunds has passed. Written requests for refunds will be considered only in extenuating circumstances.</p>";
		} else {
			$result .= "<p class=\"bold\">Refunds will be made only upon written request. Please review the <span class=\"i\">Esprit</span> Refund Policy below.</p>";
		}

		/*	Process escalating fees warning.
			Ugly hand-coded date checking for now. */

		if ($form_type =='Single') {
			$paydeadline = '';
			if ($check['rate_tier']['1']) {
				$paydeadline = $date_text['tier2'];
			};
			if ($check['rate_tier']['2']) {
				$paydeadline = $date_text['tier3'];
			};
			if ($check['rate_tier']['3']) {
				$paydeadline = $date_text['tier4'];
			};
			if ($check['rate_tier']['4']) {
				$paydeadline = $date_text['tier5'];
			};

			$result .= "<p class=\"bold\">These rates ONLY apply if you pay in full BEFORE $paydeadline. Rates and payment due increase each month, regardless of when you register.</p>";
		}
	}
	if (TESTING == true) {
		$result .= "<button onClick=\"return false;\" name=\"ShowFields\" class=\"ShowFields\">Show Debugging Fields</button></br>";
	}
	return $result;
}

function postamble() {

	/*	Generate postamble code */


	return '</div></div>';
}
	
function table($db, $form_type, $title, $brunch_ok = true) {

	/*	Generate table of rates for this form_type. */
	
	global $check, $date, $date_text, $package, $daynames, $mealnames;
	
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
require_once "mysql_utilities.php";


	/*	From config.php, we get $package, which is the full set of rates
		currently in effect for each type of form.
		$package is an array: $package[$pkgname] = array( ). Each element contains code, rate, notes and meal info */
	
	mysql_login();
	
	for ($tier_no = 1 ; $tier_no <= 6 ; $tier_no++) {
		if ($check['rate_tier'][$tier_no] == 1) {
			$this_tier = $tier_no;
			break;
		};
	}
	if ($this_tier == 0) die("Invalid tier number $this_tier in ratetable!");
	$package = array();	//	Get rid of old package definitions,
	
	if (ONLINE_ESPRIT == true) {	//	Online-only format this year?	
		$sql = "SELECT * FROM regpackages WHERE pkg_tier=$this_tier
			AND (pkg_available IS NULL
				OR pkg_available='Yes')
			AND pkg_form_type=\"$form_type\"
			AND pkg_type=\"Online\"
			ORDER BY id";
	} else {
		$sql = "SELECT * FROM regpackages WHERE pkg_tier=$this_tier
			AND (pkg_available IS NULL
				OR pkg_available='Yes')
			AND pkg_form_type=\"$form_type\"
			AND pkg_type!=\"Online\"
			ORDER BY id";
	}
	$sql_result = mysqli_query($GLOBALS['dbConnect'], $sql) or die(__FILE__.'/'.__LINE__.': Database error on main query: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sql);
	while ($row = mysqli_fetch_assoc($sql_result)) {
		$package[$row['pkg_name']] = $row;
	}
	mysql_logout();	//	Disconnect from database

// print '<pre>';
// print_r($package);
// print '</pre>';

	$this_package_keys = array_keys($package);	// extract name of the package
	$this_package_name = $this_package_keys[0];
	$result = '';
	// $result .= $this_package_name; // debug

	// print_r($package);	// debug
	
	// extract the package contents for just this form,to simplify things
	$this_package = $package;
	$display_title = ($title == '') ? "$this_package_name $form_type" : $title;
	$result .= '<table width="100%" class="section person">';
	$result .= "<tr><td colspan=\"3\" class=\"headerbar\">$display_title</td></tr>";
	$result .= '<td class="bold" width="20%">Days</td>
	<td class="bold" width="10%">Fee</td>
	<td class="bold" width="10%">Tax</td>
	<td class="bold" width="80">Notes</td></tr>';
	foreach ($this_package as $rate_key => $this_rate) {	// walk through the rates available in this package
	
	//	Combine all meals into a comma-separated string to keep legacy code happy
		$m = "{$this_rate['pkg_mealfb']},{$this_rate['pkg_mealfl']},{$this_rate['pkg_mealfd']},{$this_rate['pkg_mealsl']},{$this_rate['pkg_mealsd']},{$this_rate['pkg_mealub']}";
// 		print __FUNCTION__ . ":\$this_rate:<pre>";print_r($m); print '</pre>';

	//	Combine all days into a comma-separated string
		$d = "{$this_rate['pkg_days1']},{$this_rate['pkg_daym']},{$this_rate['pkg_dayt']},{$this_rate['pkg_dayw']},{$this_rate['pkg_dayr']},{$this_rate['pkg_dayf']},{$this_rate['pkg_daya']},{$this_rate['pkg_days2']}";
// 		print __FUNCTION__ . ":\$this_rate:<pre>";print_r($m); print '</pre>';

		$result .= '
		
		';				//	Add some spacing in HTML source listing
		
		/*
			Special rate codes are suffixed with "SR" (like 1A-S-SR"). These are only shown to specific users whose email address appears in the regcontrol table with a code of "Special Rate". That code is tested for in the blacklist.php validator file when the email address is entered. The blacklist.php code shows or hides the specialrate class via jQuery as required. */
		
		if (substr($this_rate['pkg_code'], 5, 2) == 'SR') {		//	Special rate?
			$result .= '<tr class="specialrate">';	//	Yes, display if enabled
		}elseif (substr($this_rate['pkg_code'], 5, 2) == 'LT') {		//	Special rate?
			$result .= '<tr class="speciallt">';	//	Yes, display if enabled
		} else {
			$result .= '<tr>';
		}
		$result .= "
		<td width=\"20%\"><span class=\"bold\">$rate_key ({$this_rate['pkg_code']})</span></td>";
		$result .= "
		<td>
		<input type=\"radio\" name=\"{$db}[{$form_type}][fee]\" testdata=\"no\" class=\"validate[required] radio\" value=\"{$this_rate['pkg_rate']}\" ";
		$result .= 'onChange="';
		$result .= "mealupdate('$form_type', '{$this_rate['pkg_code']}', '$m');";
		$result .= "dayupdate('$form_type', '{$this_rate['pkg_code']}', '$d');";
		$result .= "taxupdate('$form_type', '{$this_rate['tax']}');";
		$result .= '" />';
		$result .= '$' . sprintf('%.2f', $this_rate['pkg_rate']) . "</td>";
		$result .= '<td>$' . sprintf('%.2f', $this_rate['tax']) . "</td>";
		$result .= "<td>
		{$this_rate['pkg_notes']}";
		if ($this_rate['pkg_readmore'] != '') {
			$result .= "<span onclick=\"return hs.htmlExpand(this, {contentId:'pkg_{$this_rate['id']}', width: '300px', height: '300px'})\">&nbsp;<img src=\"../images/sm_help.png\" style=\"height:1.5em\">Details</span><div class=\"highslide-html-content \" id=\"pkg_{$this_rate['id']}\" style=\"display:none\">{$this_rate['pkg_readmore']}</div>";
		}

		$result .= "</td>
		</tr>";
	}
	if (substr($this_rate['pkg_code'], 0, 2) == 'SD') {	//	Selected days, put
														//	up checkbox array
		$result .= "<tr>
			<td>
			<table><tr>
			";
		$result .= days($daynames, $form_type, $db);
		$result .= "</tr>
		</table>
		</td></tr>";
	}	/*	If days are not selected here, then they are picked up from the
			package definitions when the form is submitted and processed */
		/*	Ask about Veterans' Breakfast only if enabled, otherwise it defaults
			to 0 and can't be changed. */

// 		print __FUNCTION__ . ":\$mealnames:<pre>";print_r($mealnames); print '</pre>';


// 	if ($mealnames['meal1']['enabled']) {
// 		$result .= "<tr>
// 			<td colspan=\"2\" class=\"reqd\">Do you plan to attend the Veterans' Breakfast on Friday morning?</td>
// 			<td><input type=\"radio\" class=\"validate[required] radio\" name=\"noupload[{$form_type}__meal1temp]\" onClick=\"mealbutton('$form_type', '__meal1', 1)\" />Yes
// 				<input type=\"radio\" class=\"validate[required] radio\" name=\"noupload[{$form_type}__meal1temp]\" value=\"0\"  onClick=\"mealbutton('$form_type', '__meal1', 0)\" />No
// 			</td>
// 		</tr>";
// 	}

	if (ONLINE_ESPRIT == false) {
		if ($brunch_ok) {	//	False comments this out for now.
						//	Certain attendees don't get offered brunch (e.g.
						//	Assistants) and table() will be called with "false
			$result .= "<tr>
				<td colspan=\"3\" class=\"reqd reqdhilite\">Do you plan to stay for the Sunday Farewell Breakfast?&nbsp;<input type=\"radio\" class=\"validate[required] radio\" name=\"noupload[{$form_type}__meal6temp]\" onClick=\"mealbutton('$form_type', '__meal6', 1)\" />Yes
					<input type=\"radio\" class=\"validate[required] radio\" name=\"noupload[{$form_type}__meal6temp]\" testdata=\"no\" onClick=\"mealbutton('$form_type', '__meal6', 0)\" />No
				</div>
				</td>
			</tr>";
		}
	}
	
	if (ONLINE_ESPRIT == false) {
		/*	See if a specific meal is requested. */
			if ($this_rate['pkg_meal_selectable'] == 1) {

				$result .= '<tr>
					<td colspan="2" class="reqd">You\'re entitled to one of the Esprit Meals. Please pick one*:';
				$result .= helpbutton('businessmealshelp.php');
				$result .= '</td>';

				$result .= "<td>" . meals($mealnames, $this_rate['pkg_code'], $form_type) .'</td></tr>';
			}
		}
	
	/*	Collect any special meal requirements */
	if (ONLINE_ESPRIT == false) {
		$result .= "<tr>
			<td colspan=\"3\" class=\"reqd reqdhilite\">Do you have any special dietary requirements or allergies? <input type=\"radio\" value=\"Yes\" class=\"validate[required] radio\" name=\"noupload[{$form_type}__spmealenable]\" testdata=\"no\" id=\"{$form_type}__spmealenableyes\" onClick=\"$('.spmeals__{$form_type}').show()\" />Yes
			<input type=\"radio\" value=\"Yes\" class=\"validate[required] radio\" name=\"noupload[{$form_type}__spmealenable]\" testdata=\"no\" id=\"{$form_type}__spmealenableno\" onClick=\"$('.spmeals__{$form_type}').hide()\" />No
			</div>
			</td>
		</tr>";
		$result .= "<tr class=\"spmeals__{$form_type}\">
			<td></td>
			<td class=\"reqd\">Please check all that apply. Please use \"Other\" ONLY to specify major allergies and medical requirements:" . helpbutton('specialmealshelp.php', 'more info') . "</td>
			<td><div class=\"$form_type\">";
			global $specialmealrequests;
			$break = 0;	//	Two column switch
			foreach ($specialmealrequests as $this_request) {
				$result .="
				<input type=\"checkbox\" class=\"specialmealtype\" testdata=\"no\" name=\"noupload[{$form_type}][specialmealtype][{$this_request}]\" id=\"{$form_type}__specialmealtype_{$this_request}\" value=\"{$this_request}\" />{$this_request}";
				if ($break == 1) {
					$result .= '<br />';
				}
				$break = 1 - $break;
			}
			$result .="
			<br />
			Other:<input type=\"text\" size=\"30\" class=\"specialmealtypeother\" name=\"noupload[{$form_type}][specialmealtype][Other]\" id=\"{$form_type}__specialmealtype_Other\" value=\"\" />
			<input type=\"hidden\" class=\"specialmealnote\" id=\"mealnotes__{$form_type}\" name=\"reg[{$form_type}][mealnotes]\"/>
			</div></td>
		</tr>";
	}
	$result .= '</table>';
	
		/*	Get remaining meal fields. Note meal1 is excluded (obsolete
			Veterans' Breakfast) */
		$result .= "<div class=\"invisible\">Meal debug fields</div>";
	// 	$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__meal1\" name=\"{$db}[{$form_type}][meal1]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__meal2\" name=\"{$db}[{$form_type}][meal2]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__meal3\" name=\"{$db}[{$form_type}][meal3]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__meal4\" name=\"{$db}[{$form_type}][meal4]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__meal5\" name=\"{$db}[{$form_type}][meal5]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__meal6\" name=\"{$db}[{$form_type}][meal6]\" value=\"0\" />";

		/*	Set up day fields */
		$result .= "<div class=\"invisible\">Day debug fields</div>";
	
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__daysun1\" name=\"{$db}[{$form_type}][daysun1]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__daymon\" name=\"{$db}[{$form_type}][daymon]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__daytue\" name=\"{$db}[{$form_type}][daytue]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__daywed\" name=\"{$db}[{$form_type}][daywed]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__daythu\" name=\"{$db}[{$form_type}][daythu]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__dayfri\" name=\"{$db}[{$form_type}][dayfri]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__daysat\" name=\"{$db}[{$form_type}][daysat]\" value=\"0\" />";
		$result .= "<input class=\"invisible mealspec\" testdata=\"no\" id=\"{$form_type}__daysun2\" name=\"{$db}[{$form_type}][daysun2]\" value=\"0\" />";
	/*	Set up ratepkg field */

	$result .= "<input class=\"invisible\" testdata=\"no\" id=\"{$form_type}__ratepkg\" name=\"{$db}[{$form_type}][ratepkg]\" testdata=\"no\" />";
		/*	Set up tax fields */
		$result .= "<div class=\"invisible\">Tax debug field</div>";
	$result .= "<input class=\"invisible\" testdata=\"no\" id=\"{$form_type}__tax\" name=\"{$db}[{$form_type}][tax]\" testdata=\"no\" />";
	return $result;
}
	
}
?>
