<?php
define('QUADODO_IN_SYSTEM', true);
require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
if (TESTING) {	// TESTING constant is set in config.php
	$today_text = $_REQUEST['date'] ?? 'now';
	$test_msg = 'TEST';
} else {
 	$today_text = 'now';
 	$test_msg = '';
}

require_once 'form_functions.php';

$committee = $_REQUEST['password'] ?? false;
$scholarship = $_REQUEST['override'] ?? false;
$vendor = $_REQUEST['override'] ?? false;
$presenter = $_REQUEST['override'] ?? false;

//	require_once 'head.php';	//	Not used in initial launching form.

$committee_login = ($committee == $committee_override);
$scholarship_login = ($scholarship == $scholarship_override);
$vendor_login = ($vendor == $vendor_override);
$presenter_login = ($presenter == $presenter_override);

/*	Create a date parameter for the URLs below that will propagate a
	user-supplied date from one page to the next. note two formats, one for only
	parameter (with "?") and one for additional parameter {with "&"). */

$date_param = (isset($_REQUEST['date']) ? 'date=' . $_REQUEST['date'] : '');
$date_param2 = (isset($_REQUEST['date']) ? '&date=' . $_REQUEST['date'] : '');

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<meta http-equiv="X-UA-Compatible" content="IE=edge" />
<link rel="stylesheet" href="/css/styles.css" type="text/css" media="all" />
<link rel="stylesheet" href="mgrlib/css/validationEngine.jquery.css" type="text/css"/>
<link rel="stylesheet" href="mgrlib/css/jquery.placeholder.css" type="text/css"/>
<link rel="stylesheet" href="/mgrcss/fonts.css" type="text/css" />
<link href="/lib/fonts/stylesheet.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="mgrlib/js/jquery.js"></script>
<script type="text/javascript" src="/lib/js/jquery.validationEngine-en.js" charset="utf-8"></script>
<script type="text/javascript" src="/lib/js/jquery.validationEngine.js" charset="utf-8"></script>
<script type="text/javascript" src="mgrlib/js/jquery.placeholder.js" charset="utf-8"></script>
<script type="text/javascript" src="/divs/form_js.js" charset="utf-8"></script>

<!-- Include JQuery UI-->
<script type="text/javascript" src="mgrlib/js/jquery-ui.js"></script>
<link rel="stylesheet" href="mgrlib/css/reg-theme/jquery-ui-1.10.3.custom.css" type="text/css" media="all" />

<script type="text/javascript">
	$(function() {
	$( "#tabs" ).tabs().addClass( "ui-tabs-vertical" );
	$( "#tabs li" ).removeClass( "ui-corner-top" ).addClass( "ui-corner-left" );
	});
</script>

<script type="text/javascript" src="/lib/js/highslide/highslide-with-html.js"></script>
<script type="text/javascript" src="/lib/js/highslide/highslide-config_noslide.js"></script>
<link rel="stylesheet" type="text/css" href="mgrlib/js/highslide/highslide.css" />

<!-- place last so it can override jQuery styles-->
<style>

	body {
		width: inherit;
	}
	.ui-tabs-vertical {
	/*	overall width of tab area, including tabs and content */
		width: 100%;
		float: left;
	}
	.ui-tabs-vertical .ui-tabs-nav {
	/*	Tab dimensions (must fit within .ui-tabs-vertical and still leave room
		for the .ui-tabs-panel (below) */
		/*! padding: .2em .1em .2em .2em; */
		float: left;
		width: 15%;
	}
	.ui-tabs-vertical .ui-tabs-nav li {
		clear: left;
		width: 100%;
		border-bottom-width: 1px !important;
		border-right-width: 0 !important;
	}
	.ui-tabs-vertical .ui-tabs-nav li a {
		display: block;
	}
	.ui-tabs-vertical .ui-tabs-nav li.ui-tabs-active {
		padding-bottom: 0;
		padding-right: .1em;
		border-right-width: 1px;
		border-right-width: 1px;
	}
	.ui-tabs-vertical .ui-tabs-panel {
	/*	Tab content area. Must fit within .ui-tabs-vertical while leaving enough
		width for the .ui-tabs-vertical items. */
		margin-right: 0;
		/*! margin-top: -1em; */
		padding: 0;
		float: left;
		width: 84%;
		background-color: transparent;
	}
	.ui-state-default a, .ui-state-default a:link, .ui-state-default a:visited {
	/*	Link colour in inactive tabs */
		color: white;
	}
	.ui-state-active a, .ui-state-active a:link, .ui-state-active a:visited {
	/*	Link colour in active tab */
		color: #4689CF;
	}
	.ui-tabs-vertical .ui-tabs-iframe {
		float: right;
		width: 21.8em;
		background: transparent;
		padding: 0;
		margin: 0;
	}
	.ui-tabs-vertical .ui-state-default {
		background-color:  #4689CF;
		background-image: none;
		color: #FFFFFF;
		border-radius: 6px 0px 0px 6px;
		border: none;
	}
	.ui-tabs-vertical .ui-state-active {
		background-color: #FFFFFF;
		color: #4689CF;
		background-image: none;
		border: 1px solid #4689CF;
	}
	.ui-tabs-vertical .ui-widget-header {
		background: none;
	}
	.ui-widget-content, .ui-widget-header {
		border: none;
	}
	.ui-tabs-vertical a {
		color: #4689CF;
	}
	#tabs {
		background: transparent;
	}
	.ui-tabs-nav li {
		white-space: normal !important;
		border: none;
	}
	
	#apDiv2 {
		float:left;
		/*! position:relative; */
		left:36px;
		top:300px; 
		z-index:2;
		width: 70%;
	}
	#calendar {
		float:left;
		position:relative;
		width:320px;
		z-index:3;
	/*	height: 631px; */
	}
	#endDiv {
	/*	clear:both; */
		float:left;
		width: 436px;
	}
	td {
		font-size: inherit;
	}

</style>
<title>Esprit <?php print $esprit_year;?> Online Registration <?php print $test_msg;?></title>
</head>
<body>
<img src="images/montage.png" />
<h1>Welcome to Esprit <?php print $esprit_year;?>!</h1>

<?php
if  
(file_exists("{$_SERVER['DOCUMENT_ROOT']}/../manager/lib/.auth/$esprit_year/.urgent_message_index_header.php")) {
	require_once("$esprit_year/.urgent_message_index_header.php");
};
?>
<?php
if (file_exists("lockfile.lock")) {
	print "<div class=\"urgent\">Sorry - this site is currently locked. Please try again later.<br /></div>";
	exit;
}
?>
</html>
<?php
if (file_exists('lockfile.lock')) {
	print '<span class="errormsg" style="font-size: 130%">Sorry - our online registration system is temporarily unavailable for maintenance. Please visit us again later.</span>';
} elseif ($check['registration_not_yet_open']
	and $check['vendor_registration_not_yet_open']
	and $check['presenter_registration_not_yet_open']
	and $check['committee_registration_not_yet_open']) {
	print '<h3 style="color:red">General Online Registration is not yet open! Please visit us again on ' . $date_text['registration_open'] . '.</h3>';
	print ' <span class="abutton" style="background-color: deeppink; padding: .5em; font-size: 1.2em"><a href="snippets/indexdonor.php">Donate to Esprit anytime!</a></span>';
} elseif (!$check['registration_open']
	and !$check['onsite_registration_open']
	and !$check['vendor_preregistration_open']
	and !$check['presenter_preregistration_open']
	and !$check['committee_preregistration_open']) {
	print '<span class="errormsg"> Online registration is closed!</span> <span class="abutton" style="background-color: deeppink; padding: .5em; font-size: 1.2em"><a href="snippets/indexdonor.php">Donate to Esprit anytime!</a></span>';
} else { ?>
	<p class="i tiny">Please note: this is the transgender convention held annually in Port Angeles, Washington. The conference and organization is not associated or connected with the global apparel company Esprit or its marks.</p>
<?php if (TESTING) {
	print '<p><span class="errormsg">The Registration System is in TEST MODE. </span>' . helpbutton("testmodehelp.php") . '</p>';
}
?>
<p>Registering is pretty straightforward. To start, select one of the blue tabs at the left below. If you need help, click these Help buttons <?php print helpbutton('helpbuttonhelp.php');?> for lots of helpful information.
<?php
if (file_exists("{$_SERVER['DOCUMENT_ROOT']}/../manager/lib/.auth/$esprit_year/.covid19-1.php")) {
	require_once("$esprit_year/.covid19-1.php");
};
?>
<div id="apDiv2">
	<!-- begin vertical tabs section -->
	<div id="tabs">
		<ul style="margin-top: 1.7em">
		<?php if (COVID) {?>
		<li style="background-color:#CC0000; color: white; border-color: white;"><a href="snippets/indexcovid.php">COVID Information</a>
		</li>
		<?php }?>
		<li style="background-color:#FF7744; color: white; border-color: white;"><a href="snippets/indexwhatsnew.php">New for this year</a></li>
		<?php if ($committee_login) {
			print "<li><a href=\"snippets/indexcommittee.php?password=$committee$date_param2\">Committee Members</a></li>";
// 			print "<li><a href=\"snippets/indexcommitteeold.php?password=$committee$date_param2\">Committee Members</a></li>";
			};
		$params = '';
		if ($check['registration_open']) {
			if ($date_param != '') {
				$params = "?$date_param";	//	Date only
			}
			print "<li><a href=\"snippets/indexattendee.php$params\">Attendees</a></li>";
			print "<li><a href=\"snippets/indexsoprogram.php$params\">SO Program Only</a></li>";
		} else {
			print "<li><a href=\"snippets/indexattendee.php$params\" style=\"color: #999999\">Attendee registration CLOSED</a></li>";
			print "<li><a href=\"snippets/indexsoprogram.php$params\" style=\"color: #999999\">SO Program registration CLOSED</a></li>";
		}
/*
	Assemble params for date and override for vendors
*/
		if ($date_param != '' and $vendor_login) {
			$params = "?$date_param&override=$vendor";	//	Both
		} elseif ($date_param != '') {
			$params = "?$date_param";	//	Date only
		} elseif ($vendor_login) {
			$params = "?override=$vendor";	//	Date only
		} else {
			$params = "";	//	Override only
		}
		if ($check['vendor_preregistration_open']) {
			print "<li><a href=\"snippets/indexvendor.php$params\">Vendors</a>";
		} else {
			print "<li><a href=\"snippets/indexvendor.php$params\" style=\"color: #999999\">Vendor registration CLOSED</a>";
		}

/*
	Assemble params for date and override for presenters
*/
		if ($date_param != '' and $presenter_login) {
			$params = "?$date_param&override=$presenter";	//	Both
		} elseif ($date_param != '') {
			$params = "?$date_param";	//	Date only
		} elseif ($presenter_login) {
			$params = "?override=$presenter";	//	Date only
		} else {
			$params = "";	//	Override only
		}

		if ($check['presenter_preregistration_open']) {
			print "<li><a href=\"snippets/indexpresenter.php$params\">Presenters</a>";
		} else {
			print "<li><a href=\"snippets/indexpresenter.php$params\" style=\"color: #999999\">Presenter registration CLOSED</a>";
		}
		
		print "<li><a href=\"snippets/indexpresentervendor.php$date_param\">Presenter/Vendors</a>";
		print ($check['presenter_preregistration_open'] and $check['vendor_preregistration_open']) 
			? '</li>'
			:  '<li><span class="tiny reqd">Vendor or Presenter registration is CLOSED</span></li>';

/*
	Assemble params for date and override for scholarships
*/
		if ($date_param != '' and $scholarship_login) {
			$params = "?$date_param&override=$scholarship";	//	Both
		} elseif ($date_param != '') {
			$params = "?$date_param";	//	Date only
		} elseif ($scholarship_login) {
			$params = "?override=$scholarship";	//	Date only
		} else {
			$params = "";	//	Override only
		}

		if ($check['scholarships_open'] and ONLINE_ESPRIT != true) {
			print "<li><a href=\"snippets/indexscholapp.php$params\">Scholarships</a>";
		} else {
			print "<li><a href=\"snippets/indexscholapp.php$params\" style=\"color: #999999\">Scholarships CLOSED</a>";
		}
		
		print "<li><a href=\"snippets/indexpaymentoptions.php\">Payment Options</a></li>";
		if (TESTING) {
			print "<li><a href=\"snippets/indextest.php\">TESTING</a>";
		}
		?>
		<li style="background-color: deeppink; color: #000000;"><a href="snippets/indexdonor.php">Donate to Esprit</a></li>
		<li><a href="snippets/indexguidelines.php">Guidelines</a>
			<br /><span class="tiny i">IMPORTANT information - please read!</span></li>
		<li><a href="snippets/indexqa.php">Frequently Asked Questions</a>
			<p class="tiny i">More helpful information</p></li>
	</ul>
	</div>
	<?php } ?>
	<p style="font-size:7pt"><?php print phpversion();?></p>
</div><!-- end of apDiv2-->
<div id="calendar">
	<div class="section">
		<div class="headerbar">At a glance</div>
		<?php print (ONLINE_ESPRIT == true ? 'Esprit is <span class="goodmsg">HAPPENING VIRTUALLY (ONLINE)</span>' : 'Esprit is <span class="goodmsg">HAPPENING IN PERSON</span>') . ' at this point.';
		?>
		<p>GENERAL Registration is
			<?php if ($check['registration_open']) {
	print '<span class="goodmsg">OPEN</span>';
    if (TESTING) {
	print '<span class="errormsg"> IN TEST MODE</span>';
	}
} else {
	print '<span class="errormsg">CLOSED</span>';
} ?>
			<br />
			VENDOR Registration is
			<?php if ($check['vendor_preregistration_open']) {
	print '<span class="goodmsg">OPEN</span>';
    if (TESTING) {
	print '<span class="errormsg"> IN TEST MODE</span>';
	}
} else {
	print '<span class="errormsg">CLOSED</span>';
} ?>
			<br />
			PRESENTER Registration is
			<?php if ($check['presenter_preregistration_open']) {
	print '<span class="goodmsg">OPEN</span>';
    if (TESTING) {
	print '<span class="errormsg"> IN TEST MODE</span>';
	}
} else {
	print '<span class="errormsg">CLOSED</span>';
} ?>
<!--			<br />
			Prompt payment discount is
			<?php if ($check['incentive_available']) {
	print '<span class="goodmsg">AVAILABLE</span>';
} else {
	print '<span class="errormsg">UNAVAILABLE</span>';
} ?>
			<?php print helpbutton('promptdiscounthelp.php');?>-->
			<br />
			Scholarship Applications are
			<?php if ($check['scholarships_open'] and ONLINE_ESPRIT != true) {
	print '<span class="goodmsg">OPEN</span>';
    if (TESTING) {
	print '<span class="errormsg"> IN TEST MODE</span>';
	}
} else {
	print '<span class="errormsg">CLOSED</span>';
} ?>
		</p>
	</div>
	<div class="section">
		<div class="headerbar">Important Dates</div>
		<?php
		/*	Gather all the dates we want to print, then insert today's date and sort the whole lot. No fancy colour styling. */
		if (ONLINE_ESPRIT != true) {
			$pdates['Early Vendor Registration Opens'] = $date['vendor_registration_open'];
		}
		$pdates['Early Presenter Registration Opens'] = $date['presenter_registration_open'];
		$pdates['Committee Member Registration Opens'] = $date['committee_registration_open'];
		$pdates['Online Registration Opens.
 <span style="color:darkorange">Register and pay NOW
 for maximum discount!</span>'] = $date['registration_open'];
		if (ONLINE_ESPRIT != true) {
			$pdates['Online Scholarship Applications Open'] = $date['registration_open'];
			$pdates['Esprit Scholarship Application Deadline'] = $date['scholarships_deadline'];
		}
		$pdates['Deadline for full refund'] = $date['refund_full_deadline'];
		$pdates["Deadline for 50% refund. <span class=\"reqd\">
 No refund after this date; partial credit towards next year's attendance.</span>"] = $date['refund_50_deadline'];
		$pdates['Deadline for receipt of mailed-in payment.
 <br /><span class="bold">After today you must pay in person on arrival 
 (cash, check or credit card using PayPal accepted)</span>'] = $date['payment_deadline'];
		if (ONLINE_ESPRIT != true) {
			$pdates['Deadline for Vendor Registration'] = $date['vendor_registration_deadline'];
		}
		$pdates['Deadline for Presenter Registration'] = $date['presenter_registration_deadline'];
		$pdates['Online Registration Closes'] = $date['registration_closed'];
		if (ONLINE_ESPRIT != true) {
			$pdates['<span style="color:darkorange">Early Discount REDUCED</span> by $10 (T2)'] = $date['tier2'];
			$pdates['<span style="color:darkorange">Early Discount REDUCED</span> by another $10 (T3)'] = $date['tier3'];
			$pdates['<span style="color:darkorange">Early Discount REDUCED</span> by another $10 (T4)'] = $date['tier4'];
			$pdates['<span style="color:darkorange">NO Early Discount</span> (T5)'] = $date['tier5'];
		}
		$pdates['Esprit BEGINS'] = $date['esprit_start'];
		$pdates['Esprit ENDS'] = $date['esprit_end'];
		$pdates["<span class=\"reqd i\"><--	Today (it's " . $today->format('g:ia T') . ")</span>"] = $today;
		asort($pdates);

/*	Generate table */

		print '<table><tr><td width="30%"></td><td></td>';
		foreach ($pdates as $this_key => $this_date) {
			print "<tr><td class=\"bold\">" . $this_date->format('d M Y') . "</td><td>$this_key</td></tr>";
		}
		print '</table>';
		export_ical($pdates, $today);

/*	End of table generation */

		print '<p>' . helpbutton('ical-how-to2.php', 'Add these dates to your own calendar app', 800, 400);
?> </p>
	</div>
	<div class="section">
		<div class="headerbar">You can also:</div>
		<p>
		<?php if ($committee_login) {
    print '<a href="regstats/index.php">View the registration statistics charts</a><br />';
} ?>

<a href="https://www.facebook.com/groups/espritconf">Join the Esprit Facebook group</a> <br />
<a href="https://www.espritgala.org">Return to the Esprit main website. </a> </p>
	</div>
</div> <!-- end of calendar div -->
</body>
</html>

<?php
/*
	Create file of the important dates in iCalendar format
*/

function export_ical($dates, $today) {
	global $esprit_year;
	$r = <<<PREAMBLE
BEGIN:VCALENDAR
METHOD:PUBLISH
VERSION:2.0
X-APPLE-CALENDAR-COLOR:#D40404
X-WR-CALNAME:Esprit Schedule
PRODID:-//Esprit Gala//iCalendar Generator//EN
X-WR-TIMEZONE:America/Vancouver
CALSCALE:GREGORIAN
BEGIN:VTIMEZONE
TZID:America/Vancouver
BEGIN:DAYLIGHT
TZOFFSETFROM:-0800
RRULE:FREQ=YEARLY;BYMONTH=3;BYDAY=2SU
DTSTART:20070311T020000
TZNAME:PDT
TZOFFSETTO:-0700
END:DAYLIGHT
BEGIN:STANDARD
TZOFFSETFROM:-0700
RRULE:FREQ=YEARLY;BYMONTH=11;BYDAY=1SU
DTSTART:20071104T020000
TZNAME:PST
TZOFFSETTO:-0800
END:STANDARD
END:VTIMEZONE
PREAMBLE;
	$inc = 0;	//	Appended to UID field to make it unique
	foreach ($dates as $this_date => $date_data) {
		if (!strpos($this_date, 'Today ')) {
			$rdate = $date_data->format('Ymd\THis');
			/*	Extend duration to 29 minutes so it's visible in a calendar */
			$date_data->add(new DateInterval('PT29M'));
			$edate = $date_data->format('Ymd\THis');
			$now = $today->format('gYmd\THis');
			$inc++;
			$desc = "Esprit $esprit_year: " . str_replace("
	", ' ',mb_convert_encoding(strip_tags($this_date), 'UTF-8', 'HTML-ENTITIES'));
			$r .= "
BEGIN:VEVENT
SUMMARY:{$desc}
STATUS:CONFIRMED
TRANSP:TRANSPARENT
UID:esprit$esprit_year:$rdate$inc
DTSTART:$rdate
DTEND:$edate
DTSTAMP:$rdate
END:VEVENT";
		}
	}
	$r .= "
END:VCALENDAR
";
	$fname = 'esprit_dates.ics';
// 	if (file_exists($fname)) {
// 		chmod($fname, 511);	//	777 octal
// 		unlink($fname) or die("Delete existing file $fname before resize failed");
// 	}
//	Normalise line endings
	$r = str_replace(["\r\n", "\r", "\n"], "\r\n", $r);
	file_put_contents($fname, $r);

	return;
}