<?php
/*
	Check against committee list. Must NOT be on either Committee Full or Committee
	Partial list.
	This also checks for duplicate registrations based on first and last preferred names
	and email address.
*/

//	ini_set('display_startup_errors',1);
//	ini_set('display_errors',1);
//	error_reporting(-1);		//	All errors

/* Get value to check */
$validateValue = trim($_REQUEST['fieldValue'] ?? 'undefined fieldValue');
$validateValueUC = strtoupper($validateValue);
$validateId = $_REQUEST['fieldId'] ?? 'undefined fieldId';

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once 'blacklist.php';
require_once 'mysql_utilities.php';
/*
	Gather the parameters from whatever form type they were submitted from
*/

$fname = '';
$lname = '';
$email = '';
foreach(['Single', 'SO', 'Couple', 'Couple2', 'Add_Family', 'Resource_Presenter', 'Resource_Vendor', 'Committee_Full', 'Committee_Partial', 'Assistant', 'Volunteer', 'Guest', 'Observer'] as $ft) {
$fname .= trim($_REQUEST[$ft.'__firstnamepref'] ?? '');
$lname .= trim($_REQUEST[$ft.'__lastnamepref'] ?? '');
$email .= trim($_REQUEST[$ft.'__email'] ?? '');
}
$emailUC = strtoupper(trim($email));
$f = $_REQUEST['type'];	//	List type
mysql_login('Read-only');

/*	Check to see if on blacklist */
if (blacklist($validateValueUC)) {	/*	Blacklisted? */
	echo json_encode(array($validateId, false,'Registration DECLINED. Please contact registrar@espritgala.org for assistance.'));
	exit;
}

/*
	Check for duplicate.
*/
/*
	First make sure we have everything we need to check. We could be validating before all
	required fields have been entered. This is so that the check can be done regardless of
	what order the fields were entered.
*/
if (($fname != '') and ($lname != '') and ($email != '')) {	// All fields are required
//	We have all fields, we can do duplicate check
	$sqlcmd = "SELECT email found_email, DATE_FORMAT(TIMESTAMP,'%D %b, %Y') tstamp, confirmation_no conf FROM reg WHERE email=\"$email\" AND firstnamepref=\"$fname\" AND lastnamepref=\"$lname\"";

	$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": didn't work");
	$row = mysqli_fetch_assoc($result);

	/*	Do we have a matching record? */
	if ($row) {	//	Found duplicate registration, fail
		echo json_encode(array($validateId, false, "<a href=\"/duplicate_error.php?conf={$row['conf']}&email=$email\"><span style=\"font-size: 120%; color: yellow\">This looks like a duplicate registration;<br />it was first submitted on {$row['tstamp']}.<br />Please click here for help.</span></a>"));
		exit;
	}
}
/*
	Drop through to committee list check
*/

/*	Following SELECT handles wildcard "*" in checklist by replacing them with MySQL's "%" wildcard */
$sqlcmd = "SELECT email, category FROM regcontrol WHERE \"$emailUC\" LIKE (REPLACE(UPPER(TRIM(email)), '*', '%')) AND TRIM(category) LIKE \"%Committee%\"";
$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(mysqli_error($GLOBALS['dbConnect']) . ": didn't work");

if (@mysqli_num_rows($result) > 0) {	//	if a matching records found,
										//	IS on committee list

	echo json_encode(array($validateId, false,'You\'re eligible for the Committee Rate. Please select a Committee Registration Form.'));
} else {	//	Passed all the checks, it's good to go.
	echo json_encode(array($validateId, true, ''));
}
mysql_logout();	//	Disconnect from database
?>