<?php
/*
	Process submitted forms. Will generate as many records as required and insert them into the appropriate databases.
*/

require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
require_once ".config.php";
require_once ".regconnect.php";		// hostname, ID and password
require_once "mysql_utilities.php";
require_once "generate_confirmation.php";
require_once "process_functions.php";
require_once 'process_records.php';
require_once 'process_emails.php';
require_once 'process_ack_page.php';
require_once 'process_payment.php';
require_once "addonutils.php";
/*
	lock out bogus direct calls from spammers
*/
if (!isset($_POST['noupload']['appstart'])) {
	die('Invalid registration attempt.');
};
if ($_POST['noupload']['appstart'] < date('Y-m-d')) {
	require_once "tooslow.php";
	?><script>alert('Registration must be begun and submitted on the same day.');</script><?php die(tooslow(strtolower($_POST['noupload']['source_form_type'])));

};
/*	Connect to database */
	
$db = get_regconnect('Normal');
$db['db'] = 'esprit';
$db['log'] = 'reglog';	// log file

define('QUADODO_IN_SYSTEM', true);

global $esprit_year, $esprit_address, $esprit_address_text, $hist_book;

$p = $_REQUEST;
$p_raw = $p;		//	Capture for debugging
$f = $_FILES;
$f_raw = $f;		//	Capture for debugging

if (TESTING) { print paramdump($p, $f, 'In process.php'); }

/*	Add some constants that go into every field */

$constants = get_constants();

/*	Record types and tables that are linked together by confirmation number */

$master_conf_types = array('Single', 'Committee_Full', 'Committee_Partial', 'Resource_Vendor', 'Resource_Presenter');
$linked_table_types = array('regvendor', 'regpresenter', 'scholapp','regvolunteers');

/*	Add some constants that are never posted, only used for email generation */

$m = get_m();

$m['sig_agreement'] = $sig_agreement;

/*	Compute system values (usually from $_SERVER) */

$sm = get_server_vars();

/*	Process input fields and generate database records */

// print '<h4>' . __FUNCTION__ . '/' . __LINE__ . ": BEGINNING process.php</h4>";

if (in_array('noupload', array_keys($p))) { //	Capture any noupload data
	$noupload = $p['noupload'];
	$sft = $noupload['source_form_type'];	//	And source_form_type
} else {
	$noupload = array();
	$sft = '';
}
$p_clean['noupload'] = $noupload;			//	Sanitised input
		
/*	If there are checkbox-selected dates, get their values and set the actual
	corresponding fields. They show up as noupload['days'][$form_type] values.
*/
if (isset($noupload['days']))	{	//	This array exists if checkbox dates were used
	foreach($noupload['days'] as $form_type => $t) {
		foreach($t as $this_meal => $mindex) {
			$p['reg'][$form_type][$mindex] = 1;
		}
	}
}

// print '<h4>' . __FUNCTION__ . '/' . __LINE__ . ": Initialised \$p_clean: </h4><pre>"; print_r($p_clean); print '</pre>';
mysql_login();	//	Connect to database

/*	Process each database table in the input */

foreach ($p as $this_table => &$table) {
	/*	Don't upload 'noupload' data or non-arrays! */
	if (is_array($table) and $this_table != 'noupload') {
// print '<h4>' . __FUNCTION__ . '/' . __LINE__ . ": Processing \$this_table $this_table...</h4>";

		/*	Collect any "common" data. Have to do it this way because we
			don't know in what order the parameter arrays might arrive. */

		if (in_array('common', array_keys($table))) { 	//	Any common data?
			$common = $table['common'];
		} else {
			$common = array();
		}
// print '<h4>' . __FUNCTION__ . '/' . __LINE__ . ": Extracted \$common</h4>";
		/*	Process each subrecord type in the element */
		
		foreach ($table as $this_rectype => &$rectype) {
// print '<h4>' . __FUNCTION__ . '/' . __LINE__ . ": Processing \$this_rectype $this_rectype</h4>";
			if ($this_rectype != 'common') {	//	Don't process common!
				$p_clean[$this_table][$this_rectype] = sanitise($this_table, $rectype, $common);
// print '<h4>' . __FUNCTION__ . '/' . __LINE__ . ": Sanitised \$p_clean[{$this_table}][{$this_rectype}]:</h4>";
// print '<pre>';print_r($p_clean[$this_table][$this_rectype]); print '</pre>';
				/*	Some forms have the user enter a confirmation number to link
					the record to (e.g. if someone is adding a business to the
					regvendor table, they supply the email and confirmation
					number for the vendor. This is validated at the form level
					so by the time it gets here we can simply insert it instead
					of creating a confirmation number. Such fields are named
					'noupload[preset_confirmation_no]'. */
				if (isset($noupload['preset_confirmation_no'])) {
// 					print "Got preset confirmation no. {$noupload['preset_confirmation_no']}<br />";
					$master_conf = $noupload['preset_confirmation_no'];
				} else {
					$conf = generate_confirmation();
					$password = generate_password($conf);
					$badge_code = generate_badge_code();
// die(__FILE__ .':'. __LINE__);
				}
				/*	See if we need to link by confirmation number. Certain
					database record types contain a "master" confirmation
					number which other tables link to. Capture the
					$master_conf number if required. */
				if (in_array($this_rectype, $master_conf_types)) {
					$master_conf = $conf;
				}
				/*	See if this is a linked table. If so, plug the
					$master_conf number into it, otherwise use the freshly
					generated one. While we're at it, fetch the linked-to
					information from the reg table for use in the email section.
					*/
				if (in_array($this_table, $linked_table_types)) {
					$conf = $master_conf;
					if (!isset($lookedup)) {	//	Don't do more than once!
						$sqlcmd = "SELECT *
FROM reg WHERE confirmation_no='$master_conf'";
						$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Trying to get linked-to info; Query='.$sqlcmd);
						$lookedup = mysqli_fetch_assoc($result);
						/*	Tack results onto $noupload for use in email code */
						$noupload = array_merge($noupload, $lookedup);
					}
				}
				$p_clean[$this_table][$this_rectype]['confirmation_no'] = $conf;
				$p_clean[$this_table][$this_rectype]['password'] = $password;
				$p_clean[$this_table][$this_rectype]['badge_code'] = $badge_code;
// print '<h4>' . __FUNCTION__ . '/' . __LINE__ . ": Calling process_records...</h4>";
				$r = process_records($this_table, $p_clean[$this_table][$this_rectype], $constants, $conf, $badge_code);
				/*	Is there a fee field? If so, we have to build and post a
					transaction record into regpayment. */
				if (!isset($master_conf)) {
					$master_conf = $conf;
				}
	// print '<h4>' . __FUNCTION__ . '/' . __LINE__ . ": Checking for transactions...</h4>";
			
				/*	Create a balance forward transaction first */
	// function build_bal_forward_trans($t, $conf_to_link, $this_conf, $email, $sourceacct = '', $sourceuser = '') {

	// print "Parameters passed: \$t="; print_r($rectype); print ", \$conf_to_link=$master_conf, \$this_conf=$conf, \$email={$p_clean[$this_table][$this_rectype]['email']}, \$sourceacct='onlinereg', \$sourceuser=$this_rectype<br/>";
			
				$bf_trans = build_bal_forward_trans($rectype, $master_conf,  $conf, $p_clean[$this_table][$this_rectype]['email'], 'onlinereg', $this_rectype);
				if ($bf_trans['amount'] != 0) {	//	Only post if nonzero
					$sql = sql_insert('regpayment', $bf_trans, true);
				}

			}
			if (isset($rectype['fee'])) {		//	Process fees and taxes
				$fee_trans = build_trans($rectype, $master_conf, $conf, 'onlinereg', $this_rectype);
// 				print_r($fee_trans); die();
				if ($fee_trans['amount'] != 0) {
					$sql = sql_insert('regpayment', $fee_trans, true);
				}
				$p_clean[$this_table]['transactions'][] = $fee_trans;	//	For inclusion in emails
			}

		/*	See if we have to add free items for first-timers. There's a hardcoded list of
			addon_keys in the addon_file which needs to be updated only if the item
			changes or new freebies are added.
		*/

			$override_file = "mgrlib/.auth/$esprit_year/add_free_first_timer_items.php";
			if (file_exists($override_file)) {
				include $override_file;	//	Add a free yearbook for first-timers by adding
										//	its addon_key to the array
			}

// print_r($rectype); die(__FILE__ .':' . __FUNCTION__ .':' . __LINE__);
			if (isset($rectype['p_addons']) or isset($rectype['c_addons'])) {	//	Process add-ons
				$rectype['username'] = 
				$p_addon_trans = build_addon_trans($rectype['p_addons'], $master_conf, 'onlinereg', $this_rectype);
				$c_addon_trans = @build_addon_trans($rectype['c_addons'], $master_conf, 'onlinereg', $this_rectype);
				$addon_trans = array_merge($p_addon_trans, $c_addon_trans);
//  				print_r($addon_trans);
//  				die(__FILE__ . ':' . __LINE__);
				$itable = false;
				foreach($addon_trans as $this_addon_trans => $addon_item) {
					if ($addon_item['amount'] != 0) {
						$sql = sql_insert('regpayment', $addon_item, true);
					}
					$p_clean[$this_table]['transactions'][] = $addon_item;	//	For inclusion in emails
					$itable = true;	//	Found an actual addon, generate inventory table
				}
				/*	Generate table of addon stock, spaces, seats etc. that are left if any
					addons were posted. Will be used to generate an email to registrar and
					admin. */
				$p_clean[$this_table]['addon_inventory_table'] = $itable ? get_inventory_table() : array();
			}

// 			die(__FUNCTION__ .':' . __LINE__ . "\$rectype['volsignup']={$rectype['volsignup']}<br />");
			if (array_key_exists('volsignup', $rectype)) {	//	Flag for letters
				foreach($rectype['volsignup'] as $this_vol => $vol_item) {
					$vol_data = ['vol_typename' => $vol_item, 'vol_confirmation' => $conf];
					$sql = sql_insert('regvolunteers', $vol_data, true);
					$p_clean[$this_table][$this_rectype]['volsignup'][] = $vol_data;	//	For inclusion in emails
				}
			}
		}	//	END of $rectype processing
	/*	Debugging prints */

	// 		print __FUNCTION__ . ': $p: <pre>'; print_r($p); print '</pre>';
	//		print __FUNCTION__ . ': $r: <pre>'; print_r($r); print '</pre>';
	// 		print __FUNCTION__ . ': $constants <pre>'; print_r($constants); print '</pre>';
	// 		print __FUNCTION__ . ': $m: <pre>'; print_r($m); print '</pre>';
	// 		print __FUNCTION__ . ': $sm: <pre>'; print_r($sm); print '</pre>';
	// 		print __FUNCTION__ . ': $trans: <pre>'; print_r($trans); print '</pre>';
// 			print __FUNCTION__ . ': $p_clean after processing:<pre>'; print_r($p_clean); print '</pre>';

	}	//	END of $table processing
}		//	End of all input processing.

/*	Generate emails for this table.  */
/*	Modified to include raw parameters for debug emails */

// print '<h4>Exiting process.php at ' . __LINE__ . '</h4>';exit;
process_emails($sft, $p_clean, $noupload, $f, $constants, $m, $sm, $p_raw, $f_raw);

// print __FUNCTION__ . 'Done!';
// exit;

/*	Generate acknowledgement page */

// 	print __FUNCTION__ . ': beginning ack pages; $p_clean: <pre>'; print_r($p_clean); print '</pre>';

switch ($p['noupload']['source_form_type']) {

case 'Scholarship':
	print process_ack_schol_page(array_merge($p_clean, $r, $constants, $m, $sm), $f);
	Make_Log_Entry($GLOBALS['dbConnect'], "ADDED SCHOLARSHIP APP: Confirmation no.: {$r['confirmation_no']}; Name: {$r['preferredfirst']} {$r['preferredlast']}");
	break;

case 'Donor':
	print process_ack_donor_page(array_merge($p_clean, $r, $constants, $m, $sm), $f, $p_clean['reg']['transactions'], $master_conf);
	print process_payment(array_merge($p, $r, $constants, $m, $sm), $f, $p_clean['reg']['transactions'], $master_conf);
	Make_Log_Entry($GLOBALS['dbConnect'], "ADDED NON-ATTENDING DONATION:  Name: {$r['firstnamepref']} {$r['lastnamepref']}");
	break;

default:
//	function process_ack_page($p, $f, $trans, $form_type) {

	print process_ack_page(array_merge($p_clean, $r, $constants, $m, $sm), $f, $p_clean['reg']['transactions'], $sft);
// 	print __FUNCTION__ . __LINE__ . ': ending ack pages; $p_clean: <pre>'; print_r($p_clean); print '</pre>';

	/*	Request PayPal transaction and generate if required */
	
	print process_payment(array_merge($p, $r, $constants, $m, $sm), $f, $p_clean['reg']['transactions'], $master_conf);
	Make_Log_Entry($GLOBALS['dbConnect'], "ADDED REGISTRATION: Confirmation no.: {$r['confirmation_no']}; Package: {$r['ratepkg']}; Fee: {$r['fee']}; Name: {$r['firstnamepref']} {$r['lastnamepref']}");
}

/*	Invite to next steps (another presentation/business, scholarship
	application, join various lists etc. */

// require_once 'process_conclusion.php';
// process_conclusion($p, $f);

/*	Housekeeping and cleanup */



/*	Done */

?>