<?php
function process_emails($sel, $data, $noupload, $f, $constants, $m, $sm, $p_raw, $f_raw) {

	/*	Process specified email info. Email to be sent is based on the
		regemailcontrol table which specifies the sender, recipient(s), subject,
		body, attachments and the conditions under which the email is to be
		sent. The sender, recipients, subject and body are described in Smarty
		templates. Data to be filled in is provided in the $data and $f parameters.
		
		Certain emails require data to be retrieved from the reg table. The record to be
		retrieved is identified by the email address and confirmation number.
		
		This is called once per $data processed. One call may generate multiple
		emails depending on the conditions found in the regemailcontrol table.
		
		UPDATED to use PHPMailer v6.0 on 23 July 2017.
		UPDATED to use PHPMailer v6.2 on 5 January 2021.
	*/

	/* Set up to use Smarty template engine */
	
// 	print '<pre>';
// 	print '>>>>>>>>>>>>>$sel:';var_dump($sel);
// 	print '>>>>>>>>>>>>>$data:';var_dump($data);
// 	print '>>>>>>>>>>>>>$noupload:';var_dump($noupload);
// 	print '>>>>>>>>>>>>>$f:';var_dump($f);
// 	print '>>>>>>>>>>>>>$constants:';var_dump($constants);
// 	print '>>>>>>>>>>>>>$m:';var_dump($m);
// 	print '>>>>>>>>>>>>>$sm:';var_dump($sm);
// 	print '>>>>>>>>>>>>>$p_raw:';var_dump($p_raw);
// 	print '>>>>>>>>>>>>>$f_raw:';var_dump($f_raw);
// 	print '</pre>';
// 	
// 	exit;

	require_once "{$_SERVER['DOCUMENT_ROOT']}/setpaths.php";
	require_once ".config.php";
	
//	New requires for PHPMailer 6.9.1
	require_once "PHPMailer/src/PHPMailer.php";
	require_once "PHPMailer/src/SMTP.php";
	require_once "PHPMailer/src/Exception.php";

	require_once "process_functions.php";
	require_once "mysql_utilities.php";
	if (!defined('SMARTY_DIR')) {
		define('SMARTY_DIR', "{$_SERVER['DOCUMENT_ROOT']}/mgrlib/smarty/");
	}
	require_once SMARTY_DIR.'Smarty.class.php';
	mysql_login('Normal');

/*	First log where we were called from */

	$bt = debug_backtrace(0);
	cap_print("<br/><b>Backtrace:</b><br />");
	foreach($bt AS $this_bt) {
		cap_print("{$this_bt['file']} called from {$this_bt['function']}/{$this_bt['line']}<br />");
	}

	if (false and TESTING) {
		/*	Send every email template for debugging purposes.
			Only works in test mode!!
		*/
		$sqlcmd = "SELECT * FROM regemailcontrol
			ORDER BY letter_name";
	} else {
		$online_esprit = (ONLINE_ESPRIT == true ? 'AND letter_online_esprit = "Yes"': 'AND letter_online_esprit != "Yes"');
		$sqlcmd = "SELECT * FROM regemailcontrol WHERE UPPER(TRIM(letter_group)) IN (\"$sel\", \"Common\") $online_esprit";
	}
// 	print "\$sqlcmd=$sqlcmd";exit;
		$result = mysqli_query($GLOBALS['dbConnect'], $sqlcmd) or die(__FUNCTION__.': MySQL error: '.mysqli_error($GLOBALS['dbConnect']).'. Query='.$sqlcmd);
	cap_print('', true, false);	//	Initialise debugging capture

	/*	Generate each email as an array element */
	while ($row = mysqli_fetch_assoc($result)) {
		$emailstuff = process_email($row, $data, $noupload, $constants, $m, $sm, $f);
	}

	/* Append raw parameters as submitted by user to debugging email */
	
	cap_print("<br /><br />Email is ready to send!<br /><br />");
	cap_print('Raw parameters entered (data): $p_raw:');
	cap_print($p_raw);
	cap_print('Raw parameters entered (files): $f_raw:');
	cap_print($f_raw);
	cap_print('CLEANED parameters entered (data): $p_clean:');
	cap_print($data);
	cap_print('Server variables: $_SERVER:');
	cap_print($_SERVER);

	/*	Send debugging info after all emails are sent */

	if (true) {	//	Negate to suppress debug email
		$debug = new PHPMailer\PHPMailer\PHPMailer;

	$mp = $GLOBALS['mailer_params'];	//	Shorten the code a bit :-)
	$mpid = $GLOBALS['mailer_ids'];		//	separated so as not to appear in debug emails

	cap_print('<b>Mailer parameters from .config.php</b><br />');
	cap_print($mp);

/*	Note that $GLOBALS['mailer_params'] has different values depending on whether we're
	on the developer or production server. See .config.php for details.
	
	Following code inserts those values into the $debug object.
*/
	$debug->Host = $mp['Host'];			//	Specify mail server
	$debug->SMTPAuth = $mp['SMTPAuth'];	//	Enable SMTP authentication
	$debug->Username = $mpid['Username'];	// SMTP username
	$debug->Password = $mpid['Password'];	// SMTP password
	$debug->From = $mp['From'];
	$debug->AddAddress($mp['AddAddress'][0], $mp['AddAddress'][1]);	// Add a recipient
	$debug->SMTPSecure = $mp['SMTPSecure'];	//	Use ssl connection
	$debug->Port = $mp['Port'];			//	on this port

// 	$debug->SMTPDebug = MAIL_DEBUG_LEVEL;	//	Uncomment these two lines
// 	$debug->Debugoutput = 'html';			//	for debugging output

	$debug->IsHTML(true);					//	Set email format to HTML
	$debug->FromName = 'Mail Debugger';		//	Not copied from config.php!
	$debug->Subject = 'Mail Debug Output';
	$debug->Body = cap_print(null, false, false);
	if(!$debug->Send()) {
		print 'Debug Message could not be sent.';
		print 'Debug Mailer Error: ' . $debug->ErrorInfo;
	}

	}
	
/*	Uncomment to print cap_print debugging info on web page */
// 	cap_print(null, false, true);
}

function process_email($row, $data, $noupload, $constants, $m, $sm, $f) {

	/*	Given the database row describing the email and the array of data to be merged into it, create and send the email. */

// 	print "<h4>" . __FUNCTION__ . ": Attempting to send letter {$row['letter_group']}: {$row['letter_name']}</h4>";

//	First log where we were called from

	$bt = debug_backtrace(0);
	foreach($bt AS $this_bt) {
		cap_print("<br /><br /><b>{$this_bt['file']} called from {$this_bt['function']}/{$this_bt['line']}</b><br />");
	}

	$e = new Smarty() or die('Could not create Smarty instance');
	$e->addTemplateDir("{$_SERVER['DOCUMENT_ROOT']}/templates/");
// 	$e->debugging = true;
	foreach ($data as $this_table => $table) {
		$e->assign($table);
	}
	$e->assign('noupload', $noupload);
	$e->assign($constants);
	$e->assign($m);
	$e->assign($sm);
	$e->assign('f', $f);
	$e->assign('globals', $GLOBALS);

	$r['letter_from'] = $e->fetch('string:' . $row['letter_from']);
	$r['letter_to'] = $e->fetch('string:' . $row['letter_to']);

	/*	First evaluate the letter_rule field to see if we even want this email sent. */
	cap_print("<br /><hr /><b>Processing email control: Name={$row['letter_name']}; Letter_group={$row['letter_group']};<br /> From={$r['letter_from']};<br /> To={$r['letter_to']}; </b><br />");
	$doit = false;
	cap_print("Comments: {$row['letter_comments']}<br />");
	cap_print("Evaluating letter_rule \"{$row['letter_rule']}\"...<br />");

	if (trim($row['letter_rule']) == '') {
		$doit = true;
		cap_print("<span style=\"color:green\">Rule is blank; always send...</span><br />");
	} else {
		$rule = $e->fetch('string:' . $row['letter_rule']);
		cap_print("Processing rule {$row['letter_rule']}; got $rule from it.<br />");
		cap_print("Rule is: \"\$doit = ($rule);\"...<br />Evaluating...<br />");
 		if (TESTING) {
 			print "Rule is: {$row['letter_rule']}: \"\$doit = ($rule);\"...<br />Evaluating...<br />";
 		}
		eval("\$doit = ($rule);");
		if ($doit) {
			cap_print("<span style=\"color:green\">$doit MATCHED! Sending...</span><br />");	//	drop through to send
		} else {
			cap_print("<span style=\"color:red\">$doit FAILED! NOT sending...</span><br />");
			return;	//	Return nothing, not sending this one
		}
	}

	$r['letter_subject'] = $e->fetch('string:' . $row['letter_subject']);
	$r['letter_cc'] = $e->fetch('string:' . $row['letter_cc']);
	$r['letter_bcc'] = $e->fetch('string:' . $row['letter_bcc']);

	if ($row['letter_html_file'] != '') {	//	HTML template filename given?
		$r['letter_html'] = $e->fetch(DeAliasString($row['letter_html_file']));
	} elseif ($row['letter_html'] != '') {	//	HTML in database record?
		$r['letter_html'] = $e->fetch('string:' . DeAliasString($row['letter_html']));
	} else {
		$r['letter_html'] = '';	//	No HTML version
	}
//	Append letter template name for tracing
	$r['letter_html'] .= "<p style=\"font-size: 7pt\"><i>{$row['letter_name']}</i></p>";

/******************************************************************************/
	/*	Begin the email */
	
	$mail = new PHPMailer\PHPMailer\PHPMailer;

	$mp = $GLOBALS['mailer_params'];	//	Shorten the code a bit :-)
	$mpid = $GLOBALS['mailer_ids'];		//	separated so as not to appear in debug emails
/*	Note that $GLOBALS['mailer_params'] has different values depending on whether we're
	on the developer or production server. See .config.php for details.
	
	Following code inserts those values into the $mail object.
*/
	$mail->Host = $mp['Host'];			//	Specify mail server
	$mail->SMTPAuth = $mp['SMTPAuth'];	//	Enable SMTP authentication
	$mail->Username = $mpid['Username'];	// SMTP username
	$mail->Password = $mpid['Password'];	// SMTP password
	$mail->From = $mp['From'];
	$mail->FromName = $mp['FromName'];
	$mail->AddAddress($mp['AddAddress'][0], $mp['AddAddress'][1]);	// Add a recipient
	$mail->SMTPSecure = $mp['SMTPSecure'];	//	Use ssl connection
	$mail->Port = $mp['Port'];			//	on this port

	/*	Hardcoded test addresses */
	$testing_text = (TESTING ? 'TEST' : '');
	if (TESTING) {
		$mail->SMTPDebug = MAIL_DEBUG_LEVEL;	//	Include debugging output 
		$mail->Debugoutput = 'html';			//	while testing
		cap_print('<span style="color:orange; font-weight:bold">Address overrides disabled for testing DeAliases!</span><br />');
// 		$r['letter_to'] = 'Stephanie Mitchell|stephanie@cornbury.org';
// 		$r['letter_cc'] = 'stephanie@cornbury.org';
// 		$r['letter_bcc'] = 'stephanie@cornbury.org';
}
	/*	Parse out addresses and names */
	/*	This is kind of weird. Email addresses are in the form
		Visible Name <email@domain.com>
		but for some reason the <email@domain.com> part gets treated as an HTML tag. In
		some places the tag contents aren't displayed at all, in others a closing bogus
		</email@domain.com> tag is added.
		To circumvent this, in the database, the email formatted thus:
		
		Visible Name|email@domain.com,Another Recip|another@domain.com
		
		The data is split up as required.
	*/
	$from_temp = explode('|', $r['letter_from']);
	if ($r['letter_to'] != '') {			//	Add all To addresses
		$t = explode(",", $r['letter_to']);
		foreach ($t as $this_line) {
			$this_addr = explode('|', $this_line);
			if (count($this_addr) == 1) {	//	Nameless recipient
				$darray = explode(',',DeAlias($this_addr[0]));	// comma-separated
				foreach($darray as $da) {
					$mail->addAddress($da);
					cap_print("<br />To: address dealiased from {$this_addr[0]}: address={$da}");
				}
			} else {						//	Named recipient
				$darray = explode(',',DeAlias($this_addr[1]));	// comma-separated
				foreach($darray as $da) {
					$mail->addAddress($da, $this_addr[0]);
					cap_print("<br />To: address dealiased from {$this_addr[0]}: address={$da}");
				}
			}
			cap_print("<br />To: address added: name={$this_addr[0]}, address={$this_addr[1]}; DeAlias result: $da");
		}
	}
	$mail->addReplyTo('no-reply@espritgala.org', 'DO NOT REPLY');

	if ($r['letter_cc'] != '') {			//	Add all CC addresses
		$t = explode(",", $r['letter_cc']);
		foreach ($t as $this_line) {
			$this_addr = explode('|', $this_line);
			if (count($this_addr) == 1) {	// Nameless CC
				$darray = explode(',',DeAlias($this_addr[0]));	// comma-separated
				foreach($darray as $da) {
					$mail->addCC($da);
				}
			} else {						//	Named CC
				$darray = explode(',',DeAlias($this_addr[1]));	// comma-separated
				foreach($darray as $da) {
					$mail->addCC($da, $this_addr[0]);
				}
			}
			cap_print("<br />CC: address added: name={$this_addr[0]}, address={$this_addr[1]}; DeAlias result: $da");
		}
	}

	if ($r['letter_bcc'] != '') {			//	Add all BCC addresses
		$t = explode(",", $r['letter_bcc']);
		foreach ($t as $this_line) {
			$this_addr = explode('|', $this_line);
			if (count($this_addr) == 1) {
				$darray = explode(',',DeAlias($this_addr[0]));	// comma-separated
				foreach($darray as $da) {
					$mail->addBCC($da);	// Nameless recip
				}
			} else {
				$darray = explode(',',DeAlias($this_addr[1]));	// comma-separated
				foreach($darray as $da) {
					$mail->addBCC($da, $this_addr[0]);	// named
				}
			}
			cap_print("<br />Bcc: address added: name={$this_addr[0]}, address={$this_addr[1]}; DeAlias result: $da");
		}
	}

	$mail->WordWrap = 80;				// Set word wrap to 80 characters
	$mail->IsHTML(true);				// Set email format to HTML
	$mail->Subject = $r['letter_subject'];
	$mail->MsgHTML($r['letter_html']);	// Generate HTML and plaintext versions
	cap_print("<br />Email is being sent to:<br />
	From={$r['letter_from']}<br />
	To={$r['letter_to']}<br />
	ReplyTo=no-reply@espritgala.org (DO NOT REPLY)<br />
	Cc={$r['letter_cc']}<br />
	Bcc={$r['letter_bcc']}<br />
	Subject={$r['letter_subject']}<br />
	<br />");		

/*	Attach and embed images and attachments as required */

/******************************************************************************/
/*	Add attached photo or attachments if any. These are NOT posted to the
	database; they have been uploaded by the applicant to be attached to
	the email to the registrar or coordinator. They can also be embedded in
	the HTML version of the message (such as a photo). To embed in HTML, use
	<img src="cid:photo-filename">
*/

	if (is_array($f)) {
		foreach ($f as $this_key => $this_attach) {
			foreach ($this_attach['name'] as $this_item_key => $this_item) {
				if ($this_attach['error'][$this_item_key] == 0) {	//	Any error?
					cap_print("<br />Addition $this_key: $this_item_key");
					if (substr($this_attach['type'][$this_item_key], 0, 6) == 'image/') {	//	embeddable image?
						$mail->addEmbeddedImage(
						$this_attach['tmp_name'][$this_item_key],	// path
						$this_attach['tmp_name'][$this_item_key], 	// cid
						$this_attach['name'][$this_item_key], 	 	// name
						'base64',								// encoding
						$this_attach['type'][$this_item_key], // MIMEtype
						'inline');							// disposition
					} else {	//	Regular attachment, attach it
						$mail->addAttachment(							$this_attach['tmp_name'][$this_item_key], $this_attach['name'][$this_item_key]);	// path
					}
				}
			}
		}
	}
		
	/*	Process attachment list from database. This is a return-separated list like this:
			boolean-expression1:attachment-filename1
			boolean-expression2:attachment-filename2
		NOTE the colon separator and the ABSENCE of quotes around each section. In the
		boolean, variables are replaced by their actual value as though they were
		constants, so if they are strings they must be quoted. For example,
		'{$form_type}'=='Single'	must be written with quotes as shown since
									{$form_type} is a string, but
		{$form_type.firstesprit}=={$esprit_year}
									can be written without them since both are numbers.
		If the boolean expression is true or missing (implying always true), the
		corresponding filename will be attached. The boolean expressions use eval() so
		caution is necessary. However, they do not contain valid PHP code on their own;
		they are actually Smarty templates and variables are written as Smarty variables.
		attachment-filenames can be wildcards, which is useful for attaching, say, every file in a folder.
	*/
	if ($row['letter_attachments'] != '') {	//	Any attachments to process?
		$att = explode("\n", $row['letter_attachments']);
		cap_print('<br />Attachment specification found. Processing...');
		foreach ($att as $this_line) {
			$this_att = explode(':', $this_line);
			if (count($this_att) == 1) {	//	Conditions provided?
				$this_att[1] = $this_att[0]; //	No, move attach specs
				$this_att[0] = '';			//	Insert blank (true)
			}
			$do_att = false;
			if (trim($this_att[0]) == '') {
				$do_att = true;
			} else {
				$att_rule = $e->fetch('string:' . $this_att[0]);
			cap_print("<br />Evaluating attachment rule \"\$do_att = ($att_rule);\"...<br />");
		// 						print __FUNCTION__ . ':' . __LINE__ . ":Evaluating attachment \$att_rule='$att_rule'";
				eval("\$do_att = ($att_rule);");
				cap_print($do_att ? "$do_att Matched! Attaching {$this_att['1']}...<br />" :  "$do_att FAILED!<br />");
			}
			if ($do_att) {	//	Include this attachment?
				foreach (glob($this_att[1]) as $att_filespec) {	//	Can be a pattern
					cap_print("<br />Attached file: $att_filespec. ");
					if (is_link($att_filespec)) { // follow symlinks
						$att_file = readlink($att_filespec);
						cap_print("<br />(SYMLINKED file: $att_file)");
					} else {
						$att_file = $att_filespec;
						cap_print("<br />(REAL file: $att_file)");
					}
					cap_print('<br />');
					$mail->addAttachment($att_file);
				}			//	End of this attachment
			}  else {
				cap_print('<br />No attachment table found.<br/ >');
			}			//	End of all attachments
		}
	}

	/* Send it! */
	Make_Email_Log_Entry($r, "Online Registration ({$noupload['source_form_type']})",  'Attempting email send');

	if(!$mail->Send()) {
		print '<span class="errormsg">Sorry - we couldn\'t send your confirmation email automatically. Please email registrar@espritgala.org with your name and confirmation number (above) and we\'ll look into it.</span>';
		Make_Email_Log_Entry($r, "Online Registration ({$noupload['source_form_type']})",  "Message \"{$row['letter_name']}\" could not be sent. Mailer Error: " . $mail->ErrorInfo);
	} else {
		Make_Email_Log_Entry($r, "Online Registration ({$noupload['source_form_type']})", "Message \"{$row['letter_name']}\" successfully sent");
	}
	mysql_logout();	//	Disconnect from database
}

/*	Capture debugging output for emailing to developer */

function cap_print($var, $init = false, $print = false) {
	static $capout;
	if ($init) {
		$capout = '';
	} else {
		if (is_array($var)) {
			$pvar = '<pre>' . print_r($var, true) . '</pre><br /<br />';
		} else {
			$pvar = $var;
		}
		$capout .= $pvar;
		if ($print) print $capout;
		else return $capout;
	}
}
?>